/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.provider.FeatureProvider;

public class ProviderSelector<P extends FeatureProvider> {
    private final Class<P> providerType;
    private final List<P> providers;

    public static <P extends FeatureProvider> Builder<P> builder(Class<P> providerType, SRLogger logger) {
        return new Builder<P>(providerType, logger);
    }

    public P get() {
        Iterator<P> iterator = this.providers.iterator();
        if (iterator.hasNext()) {
            FeatureProvider provider = (FeatureProvider)iterator.next();
            return (P)((FeatureProvider)this.providerType.cast(provider));
        }
        throw new IllegalStateException("No provider available for " + this.providerType.getSimpleName());
    }

    private ProviderSelector(Class<P> providerType, List<P> providers) {
        this.providerType = providerType;
        this.providers = providers;
    }

    public static class Builder<P extends FeatureProvider> {
        private final Class<P> providerType;
        private final SRLogger logger;
        private final List<P> providers = new ArrayList<P>();

        public Builder<P> add(String providerClass) {
            try {
                this.add((P)Class.forName(providerClass).asSubclass(this.providerType));
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException || t instanceof UnsupportedClassVersionError) {
                    this.logger.debug("Did not load provider " + providerClass + " because of java version issues");
                }
                this.logger.debug("Failed to load provider " + providerClass, t);
            }
            return this;
        }

        public Builder<P> add(Class<? extends P> providerClass) {
            try {
                Constructor<P> constructor = providerClass.getConstructor(new Class[0]);
                FeatureProvider provider = (FeatureProvider)this.providerType.cast(constructor.newInstance(new Object[0]));
                this.add(provider);
            }
            catch (Throwable t) {
                this.logger.debug("Failed to load provider " + providerClass.getName(), t);
            }
            return this;
        }

        public Builder<P> add(P provider) {
            if (provider.isAvailable()) {
                this.providers.add(provider);
            }
            return this;
        }

        public P buildAndGet() {
            return new ProviderSelector(this.providerType, this.providers).get();
        }

        public Builder(Class<P> providerType, SRLogger logger) {
            this.providerType = providerType;
            this.logger = logger;
        }
    }
}

