/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CooldownStorage {
    private final Map<UUID, Long> cooldown = new ConcurrentHashMap<UUID, Long>();

    public boolean hasCooldown(UUID uuid) {
        Long expire = this.cooldown.get(uuid);
        return expire != null && expire > System.currentTimeMillis();
    }

    public int getCooldownSeconds(UUID uuid) {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.cooldown.get(uuid) - System.currentTimeMillis());
    }

    public void setCooldown(UUID uuid, int cooldownTime, TimeUnit timeunit) {
        this.cooldown.put(uuid, System.currentTimeMillis() + timeunit.toMillis(cooldownTime));
    }

    public void cleanup() {
        long current = System.currentTimeMillis();
        this.cooldown.values().removeIf(expire -> expire <= current);
    }
}

