/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.floodgate.FloodgateUtil;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.CacheStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.model.player.PlayerData;

public class PlayerStorageImpl
implements PlayerStorage {
    private final SettingsManager settings;
    private final SkinStorageImpl skinStorage;
    private final CacheStorageImpl cacheStorage;
    private final SRLogger logger;
    private final AdapterReference adapterReference;

    @Override
    public Optional<SkinIdentifier> getSkinIdOfPlayer(UUID uuid) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                return Optional.ofNullable(playerData.getSkinIdentifier());
            }
        }
        catch (StorageAdapter.StorageException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    @Override
    public void setSkinIdOfPlayer(UUID uuid, SkinIdentifier identifier) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setSkinIdentifier(identifier);
                this.adapterReference.get().setPlayerData(uuid, playerData);
            } else {
                this.adapterReference.get().setPlayerData(uuid, PlayerData.of(uuid, identifier));
            }
        }
        catch (StorageAdapter.StorageException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeSkinIdOfPlayer(UUID uuid) {
        try {
            Optional<PlayerData> optional = this.adapterReference.get().getPlayerData(uuid);
            if (optional.isPresent()) {
                PlayerData playerData = optional.get();
                playerData.setSkinIdentifier(null);
                this.adapterReference.get().setPlayerData(uuid, playerData);
            }
        }
        catch (StorageAdapter.StorageException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<SkinProperty> getSkinOfPlayer(UUID uuid) {
        return this.getSkinIdOfPlayer(uuid).flatMap(this.skinStorage::getSkinDataByIdentifier);
    }

    @Override
    public Optional<SkinProperty> getSkinForPlayer(UUID uuid, String playerName, boolean isOnlineMode) throws DataRequestException {
        Optional<SkinProperty> setSkin = this.getSkinOfPlayer(uuid);
        if (setSkin.isPresent()) {
            return setSkin;
        }
        if (FloodgateUtil.isFloodgateBedrockPlayer(uuid)) {
            this.logger.debug("Player " + playerName + " is a Floodgate player, not searching for java skin.");
            return Optional.empty();
        }
        if (isOnlineMode && !this.settings.getProperty(LoginConfig.ALWAYS_APPLY_PREMIUM).booleanValue()) {
            return Optional.empty();
        }
        boolean defaultSkinsEnabled = this.settings.getProperty(StorageConfig.DEFAULT_SKINS_ENABLED);
        if (defaultSkinsEnabled && this.settings.getProperty(StorageConfig.DEFAULT_SKINS_PREMIUM).booleanValue()) {
            return this.getDefaultSkin();
        }
        Optional<MojangSkinDataResult> premiumSkin = this.skinStorage.getPlayerSkin(playerName, false);
        if (premiumSkin.isPresent()) {
            return premiumSkin.map(MojangSkinDataResult::getSkinProperty);
        }
        if (defaultSkinsEnabled) {
            return this.getDefaultSkin();
        }
        return Optional.empty();
    }

    private Optional<SkinProperty> getDefaultSkin() {
        List<String> skins = this.settings.getProperty(StorageConfig.DEFAULT_SKINS);
        if (skins.isEmpty()) {
            return Optional.empty();
        }
        String selectedSkin = skins.size() == 1 ? skins.get(0) : skins.get(ThreadLocalRandom.current().nextInt(skins.size()));
        return this.skinStorage.findSkinData(selectedSkin).map(InputDataResult::getProperty);
    }

    @Inject
    public PlayerStorageImpl(SettingsManager settings, SkinStorageImpl skinStorage, CacheStorageImpl cacheStorage, SRLogger logger, AdapterReference adapterReference) {
        this.settings = settings;
        this.skinStorage = skinStorage;
        this.cacheStorage = cacheStorage;
        this.logger = logger;
        this.adapterReference = adapterReference;
    }
}

