/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.player.LegacyPlayerData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;

public interface StorageAdapter {
    public void init();

    public Optional<PlayerData> getPlayerData(UUID var1) throws StorageException;

    public void setPlayerData(UUID var1, PlayerData var2);

    public Optional<PlayerSkinData> getPlayerSkinData(UUID var1) throws StorageException;

    public void removePlayerSkinData(UUID var1);

    public void setPlayerSkinData(UUID var1, PlayerSkinData var2);

    public Optional<URLSkinData> getURLSkinData(String var1, SkinVariant var2) throws StorageException;

    public void removeURLSkinData(String var1, SkinVariant var2);

    public void setURLSkinData(String var1, URLSkinData var2);

    public Optional<URLIndexData> getURLSkinIndex(String var1) throws StorageException;

    public void removeURLSkinIndex(String var1);

    public void setURLSkinIndex(String var1, URLIndexData var2);

    public Optional<CustomSkinData> getCustomSkinData(String var1) throws StorageException;

    public void removeCustomSkinData(String var1);

    public void setCustomSkinData(String var1, CustomSkinData var2);

    public Optional<LegacySkinData> getLegacySkinData(String var1) throws StorageException;

    public void removeLegacySkinData(String var1);

    public Optional<LegacyPlayerData> getLegacyPlayerData(String var1) throws StorageException;

    public void removeLegacyPlayerData(String var1);

    public Map<String, String> getStoredGUISkins(int var1);

    public void purgeStoredOldSkins(long var1) throws StorageException;

    public Optional<MojangCacheData> getCachedUUID(String var1) throws StorageException;

    public void setCachedUUID(String var1, MojangCacheData var2);

    default public void migrateLegacyPlayer(String playerName, UUID uuid) throws StorageException {
        Optional<LegacyPlayerData> legacyPlayerData = this.getLegacyPlayerData(playerName);
        if (!legacyPlayerData.isPresent()) {
            return;
        }
        Optional<CustomSkinData> customSkinData = this.getCustomSkinData(legacyPlayerData.get().getSkinName());
        PlayerData playerData = customSkinData.isPresent() ? PlayerData.of(uuid, SkinIdentifier.ofCustom(customSkinData.get().getSkinName())) : PlayerData.of(uuid, SkinIdentifier.of(legacyPlayerData.get().getSkinName(), null, SkinType.LEGACY));
        this.setPlayerData(uuid, playerData);
        this.removeLegacyPlayerData(playerName);
    }

    default public boolean isLegacyCustomSkinTimestamp(long timestamp) {
        if (timestamp == 0L || timestamp == -1L) {
            return true;
        }
        return timestamp >= 4102444800000L;
    }

    public static class StorageException
    extends Exception {
        public StorageException(Throwable cause) {
            super(cause);
        }
    }
}

