/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.player;

import java.util.UUID;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shared.storage.model.player.PlayerData;

public class PlayerFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private UUID uniqueId;
    private IdentifierFile skinIdentifier;
    private int dataVersion;

    public static PlayerFile fromPlayerData(PlayerData playerData) {
        PlayerFile playerFile = new PlayerFile();
        playerFile.uniqueId = playerData.getUniqueId();
        playerFile.skinIdentifier = IdentifierFile.of(playerData.getSkinIdentifier());
        playerFile.dataVersion = 1;
        return playerFile;
    }

    public PlayerData toPlayerData() {
        return PlayerData.of(this.uniqueId, this.skinIdentifier == null ? null : this.skinIdentifier.toIdentifier());
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public IdentifierFile getSkinIdentifier() {
        return this.skinIdentifier;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public static class IdentifierFile {
        private String identifier;
        private SkinVariant skinVariant;
        private SkinType type;

        public static IdentifierFile of(SkinIdentifier identifier) {
            if (identifier == null) {
                return null;
            }
            return new IdentifierFile(identifier.getIdentifier(), identifier.getSkinVariant(), identifier.getSkinType());
        }

        public SkinIdentifier toIdentifier() {
            return SkinIdentifier.of(this.identifier, this.skinVariant, this.type);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public SkinVariant getSkinVariant() {
            return this.skinVariant;
        }

        public SkinType getType() {
            return this.type;
        }

        public IdentifierFile() {
        }

        private IdentifierFile(String identifier, SkinVariant skinVariant, SkinType type) {
            this.identifier = identifier;
            this.skinVariant = skinVariant;
            this.type = type;
        }

        public static IdentifierFile of(String identifier, SkinVariant skinVariant, SkinType type) {
            return new IdentifierFile(identifier, skinVariant, type);
        }
    }
}

