/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.skin;

import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;

public class CustomSkinFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private String skinName;
    private String value;
    private String signature;
    private int dataVersion;

    public static CustomSkinFile fromCustomSkinData(CustomSkinData customSkinData) {
        CustomSkinFile customSkinFile = new CustomSkinFile();
        customSkinFile.skinName = customSkinData.getSkinName();
        customSkinFile.value = customSkinData.getProperty().getValue();
        customSkinFile.signature = customSkinData.getProperty().getSignature();
        customSkinFile.dataVersion = 1;
        return customSkinFile;
    }

    public CustomSkinData toCustomSkinData() {
        return CustomSkinData.of(this.skinName, SkinProperty.of(this.value, this.signature));
    }

    public String getSkinName() {
        return this.skinName;
    }

    public String getValue() {
        return this.value;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }
}

