/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.subjects.messages.Message;

public class LocaleManager {
    private final Map<Message, Map<Locale, String>> messages = new EnumMap<Message, Map<Locale, String>>(Message.class);
    private final Locale defaultLocale = Locale.ENGLISH;

    public void addMessage(Message key, Locale locale, String message) {
        this.messages.computeIfAbsent(key, k -> new HashMap()).put(locale, message);
    }

    public void verifyValid() {
        for (Message message : Message.values()) {
            if (this.messages.containsKey((Object)message)) continue;
            throw new IllegalStateException(String.format("Message %s not found", message.name()));
        }
        for (Message message : Message.values()) {
            Map<Locale, String> localeMap = this.messages.get((Object)message);
            if (localeMap.containsKey(this.defaultLocale)) continue;
            throw new IllegalStateException(String.format("Message %s does not have a default translation", message.name()));
        }
    }

    public String getMessage(Locale locale, Message key) {
        Map<Locale, String> localeMap = this.messages.get((Object)key);
        return Optional.ofNullable(localeMap.get(new Locale(locale.getLanguage(), locale.getCountry()))).orElseGet(() -> Optional.ofNullable((String)localeMap.get(new Locale(locale.getLanguage()))).orElse((String)localeMap.get(this.defaultLocale)));
    }

    @Inject
    public LocaleManager() {
    }
}

