/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.subjects.messages.LocaleManager;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.utils.LocaleParser;
import net.skinsrestorer.shared.utils.TranslationReader;

public class MessageLoader {
    private final SRPlugin plugin;
    private final LocaleManager manager;
    private final SRPlatformAdapter<?> adapter;
    private final SRLogger logger;

    public void loadMessages() throws IOException {
        this.loadDefaultMessages();
        this.loadCustomMessages();
        this.manager.verifyValid();
    }

    private void loadDefaultMessages() throws IOException {
        for (String localeFile : BuildData.LOCALES) {
            String resourcePath = "locales/" + localeFile;
            Locale locale = this.getTranslationLocale(localeFile);
            int count = 0;
            try (InputStream is = this.adapter.getResource(resourcePath);){
                for (Map.Entry<String, String> entry : TranslationReader.readJsonTranslation(is).entrySet()) {
                    this.manager.addMessage(Message.fromKey(entry.getKey()).orElseThrow(() -> new IllegalArgumentException(String.format("No message enum found for key %s", entry.getKey()))), locale, entry.getValue());
                    ++count;
                }
            }
            this.logger.debug(String.format("Loaded %d default message strings for locale %s", count, locale));
        }
    }

    private void loadCustomMessages() throws IOException {
        Path localesFolder = this.plugin.getDataFolder().resolve("locales");
        Path repositoryFolder = localesFolder.resolve("repository");
        Path customFolder = localesFolder.resolve("custom");
        Files.createDirectories(repositoryFolder, new FileAttribute[0]);
        Files.createDirectories(customFolder, new FileAttribute[0]);
        for (String localeFile : BuildData.LOCALES) {
            String resourcePath = "locales/" + localeFile;
            Path filePath = repositoryFolder.resolve(localeFile);
            try (InputStream is = this.adapter.getResource(resourcePath);){
                Files.copy(is, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(customFolder);){
            boolean found = false;
            for (Path path : stream) {
                String fileName;
                Path localeFile;
                if (Files.isDirectory(path, new LinkOption[0]) || (localeFile = path.getFileName()) == null || !this.isJson(fileName = localeFile.toString())) continue;
                if (!found) {
                    this.logger.info("Found custom translations, loading...");
                    found = true;
                }
                Locale locale = this.getTranslationLocale(fileName);
                int count = 0;
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    for (Map.Entry<String, String> entry : TranslationReader.readJsonTranslation(is).entrySet()) {
                        Optional<Message> message = Message.fromKey(entry.getKey());
                        if (!message.isPresent()) {
                            this.logger.warning("Skipping unknown message key " + entry.getKey());
                            continue;
                        }
                        this.manager.addMessage(message.get(), locale, entry.getValue());
                        ++count;
                    }
                }
                this.logger.debug(String.format("Loaded %d custom message strings for locale %s", count, locale));
            }
        }
    }

    private boolean isJson(String fileName) {
        return fileName.endsWith(".json");
    }

    private Locale getTranslationLocale(String fileName) {
        return fileName.startsWith("locale_") ? LocaleParser.parseLocaleStrict(this.stripFileFormat(fileName)) : Locale.ENGLISH;
    }

    private String stripFileFormat(String fileName) {
        return fileName.replace("locale_", "").replace(".json", "");
    }

    @Inject
    public MessageLoader(SRPlugin plugin, LocaleManager manager, SRPlatformAdapter<?> adapter, SRLogger logger) {
        this.plugin = plugin;
        this.manager = manager;
        this.adapter = adapter;
        this.logger = logger;
    }
}

