/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.util.Locale;
import java.util.Optional;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.MiniMessage;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.LocaleManager;
import net.skinsrestorer.shared.subjects.messages.Message;

public class SkinsRestorerLocale {
    private final GsonComponentSerializer gsonSerializer = GsonComponentSerializer.gson();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    @Inject
    private LocaleManager localeManager;
    @Inject
    private SettingsManager settings;
    private final SRForeign defaultForeign = () -> this.settings.getProperty(MessageConfig.LOCALE);

    public String getMessage(SRForeign foreign, Message key) {
        return this.getMessage(foreign, key, TagResolver.empty());
    }

    public String getMessage(SRForeign foreign, Message key, TagResolver ... tagResolver) {
        Component component = this.getMessageInternal(foreign, key, TagResolver.resolver(tagResolver)).orElseGet(Component::empty);
        return (String)this.gsonSerializer.serialize(component);
    }

    public Optional<String> getMessageOptional(SRForeign foreign, Message key, TagResolver ... tagResolver) {
        Optional<Component> component = this.getMessageInternal(foreign, key, TagResolver.resolver(tagResolver));
        return component.map(this.gsonSerializer::serialize);
    }

    private Optional<Component> getMessageInternal(SRForeign foreign, Message key, TagResolver tagResolver) {
        SRForeign target = this.settings.getProperty(MessageConfig.PER_ISSUER_LOCALE) != false ? foreign : this.defaultForeign;
        boolean isConsole = foreign instanceof SRCommandSender && !(foreign instanceof SRPlayer);
        Locale locale = isConsole ? this.settings.getProperty(MessageConfig.CONSOLE_LOCALE) : target.getLocale();
        String message = this.localeManager.getMessage(locale, key);
        if (message == null) {
            throw new IllegalStateException(String.format("Message %s not found", key.name()));
        }
        if (message.isEmpty()) {
            return Optional.empty();
        }
        Component component = this.miniMessage.deserialize(message, tagResolver);
        Message parent = key.getParent();
        if (!(parent == null || parent == Message.PREFIX_FORMAT && this.settings.getProperty(MessageConfig.DISABLE_PREFIX).booleanValue())) {
            return this.getMessageInternal(target, Message.PREFIX_FORMAT, TagResolver.resolver(tagResolver, Placeholder.component("message", component)));
        }
        return Optional.of(component);
    }

    public SRForeign getDefaultForeign() {
        return this.defaultForeign;
    }
}

