/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.permissions;

import java.util.Collection;
import java.util.function.Function;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.utils.Tristate;

public class Permission {
    private final String permissionString;

    public boolean checkPermission(SettingsManager settings, Function<String, Tristate> predicate) {
        Collection<PermissionGroup> permissionGroups = PermissionGroup.getGrantedBy(this);
        if (permissionGroups.isEmpty()) {
            return this.internalCheckPermission(predicate).asBoolean();
        }
        Tristate tristate = this.internalCheckPermission(predicate);
        if (tristate != Tristate.UNDEFINED) {
            return tristate.asBoolean();
        }
        for (PermissionGroup permissionGroup : permissionGroups) {
            if (permissionGroup == PermissionGroup.getDefaultGroup() && settings.getProperty(CommandConfig.FORCE_DEFAULT_PERMISSIONS).booleanValue()) {
                return true;
            }
            Tristate groupTristate = permissionGroup.getBasePermission().internalCheckPermission(predicate);
            if (groupTristate != Tristate.UNDEFINED) {
                return groupTristate.asBoolean();
            }
            Tristate wildcardTristate = permissionGroup.getWildcard().internalCheckPermission(predicate);
            if (wildcardTristate == Tristate.UNDEFINED) continue;
            return wildcardTristate.asBoolean();
        }
        return false;
    }

    public Tristate internalCheckPermission(Function<String, Tristate> predicate) {
        return predicate.apply(this.permissionString);
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    private Permission(String permissionString) {
        this.permissionString = permissionString;
    }

    protected static Permission of(String permissionString) {
        return new Permission(permissionString);
    }
}

