/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.permissions;

import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.Permission;

public enum PermissionRegistry {
    SKIN("skinsrestorer.command", Message.PERMISSION_COMMAND),
    SR("skinsrestorer.admincommand", Message.PERMISSION_ADMINCOMMAND),
    SKINS("skinsrestorer.command.gui", Message.PERMISSION_COMMAND_GUI),
    SKIN_SET("skinsrestorer.command.set", Message.PERMISSION_COMMAND_SET),
    SKIN_SET_OTHER("skinsrestorer.command.set.other", Message.PERMISSION_COMMAND_SET_OTHER),
    SKIN_SET_URL("skinsrestorer.command.set.url", Message.PERMISSION_COMMAND_SET_URL),
    SKIN_CLEAR("skinsrestorer.command.clear", Message.PERMISSION_COMMAND_CLEAR),
    SKIN_CLEAR_OTHER("skinsrestorer.command.clear.other", Message.PERMISSION_COMMAND_CLEAR_OTHER),
    SKIN_SEARCH("skinsrestorer.command.search", Message.PERMISSION_COMMAND_SEARCH),
    SKIN_UPDATE("skinsrestorer.command.update", Message.PERMISSION_COMMAND_UPDATE),
    SKIN_UPDATE_OTHER("skinsrestorer.command.update.other", Message.PERMISSION_COMMAND_UPDATE_OTHER),
    SR_RELOAD("skinsrestorer.admincommand.reload", Message.PERMISSION_ADMINCOMMAND_RELOAD),
    SR_STATUS("skinsrestorer.admincommand.status", Message.PERMISSION_ADMINCOMMAND_STATUS),
    SR_DROP("skinsrestorer.admincommand.drop", Message.PERMISSION_ADMINCOMMAND_DROP),
    SR_PROPS("skinsrestorer.admincommand.props", Message.PERMISSION_ADMINCOMMAND_PROPS),
    SR_APPLY_SKIN("skinsrestorer.admincommand.applyskin", Message.PERMISSION_ADMINCOMMAND_APPLYSKIN),
    SR_CREATE_CUSTOM("skinsrestorer.admincommand.createcustom", Message.PERMISSION_ADMINCOMMAND_CREATECUSTOM),
    SR_APPLY_SKIN_ALL("skinsrestorer.admincommand.applyskinall", Message.PERMISSION_ADMINCOMMAND_APPLYSKINALL),
    SR_PURGE_OLD_DATA("skinsrestorer.admincommand.purgeolddata", Message.PERMISSION_ADMINCOMMAND_PURGEOLDDATA),
    SR_DUMP("skinsrestorer.admincommand.dump", Message.PERMISSION_ADMINCOMMAND_DUMP),
    BYPASS_COOLDOWN("skinsrestorer.bypasscooldown", Message.PERMISSION_BYPASSCOOLDOWN),
    BYPASS_DISABLED("skinsrestorer.bypassdisabled", Message.PERMISSION_BYPASSDISABLED),
    OWN_SKIN("skinsrestorer.ownskin", Message.PERMISSION_OWNSKIN);

    private final Permission permission;
    private final Message description;

    private PermissionRegistry(String permission, Message description) {
        this.permission = Permission.of(permission);
        this.description = description;
    }

    public static Permission forSkin(String skinName) {
        return Permission.of("skinsrestorer.skin." + skinName);
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Message getDescription() {
        return this.description;
    }
}

