/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.update.DownloaderClassProvider;
import net.skinsrestorer.shared.update.UpdateCause;
import net.skinsrestorer.shared.update.UpdateCheckExecutor;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.update.UpdateDownloader;

public class UpdateCheckInit {
    private final SRPlatformAdapter<?> adapter;
    private final UpdateCheckerGitHub updateChecker;
    private final UpdateCheckExecutor updateCheckExecutor;
    private final Injector injector;

    public void run(InitCause cause) {
        DownloaderClassProvider downloaderClassProvider = this.injector.getIfAvailable(DownloaderClassProvider.class);
        UpdateDownloader downloader = downloaderClassProvider == null ? null : (UpdateDownloader)this.injector.getSingleton((Class)downloaderClassProvider.get());
        this.updateCheckExecutor.checkUpdate(cause.toUpdateCause(), this.updateChecker, downloader, true);
        int delayInt = 60 + ThreadLocalRandom.current().nextInt(181);
        this.adapter.runRepeatAsync(() -> this.updateCheckExecutor.checkUpdate(UpdateCause.SCHEDULED, this.updateChecker, downloader, false), delayInt, delayInt, TimeUnit.MINUTES);
    }

    @Inject
    public UpdateCheckInit(SRPlatformAdapter<?> adapter, UpdateCheckerGitHub updateChecker, UpdateCheckExecutor updateCheckExecutor, Injector injector) {
        this.adapter = adapter;
        this.updateChecker = updateChecker;
        this.updateCheckExecutor = updateCheckExecutor;
        this.injector = injector;
    }

    public static enum InitCause {
        STARTUP,
        ERROR;


        public UpdateCause toUpdateCause() {
            return this == STARTUP ? UpdateCause.STARTUP : UpdateCause.ERROR;
        }
    }
}

