/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.MiniMessage;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.skinsrestorer.shared.exception.TranslatableException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.SRHelpers;

public class ComponentHelper {
    private static final GsonComponentSerializer GSON_COMPONENT_SERIALIZER = GsonComponentSerializer.gson();
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final MiniMessage MINI_MESSAGE_COMPONENT_SERIALIZER = MiniMessage.miniMessage();
    private static final PlainTextComponentSerializer PLAIN_COMPONENT_SERIALIZER = PlainTextComponentSerializer.plainText();

    public static String parseMiniMessageToJsonString(String miniMessage) {
        return (String)GSON_COMPONENT_SERIALIZER.serialize(MINI_MESSAGE_COMPONENT_SERIALIZER.deserialize(miniMessage));
    }

    public static String convertJsonToPlain(String messageJson) {
        return PLAIN_COMPONENT_SERIALIZER.serialize((Component)GSON_COMPONENT_SERIALIZER.deserialize(messageJson));
    }

    public static String convertJsonToLegacy(String messageJson) {
        return LEGACY_COMPONENT_SERIALIZER.serialize((Component)GSON_COMPONENT_SERIALIZER.deserialize(messageJson));
    }

    public static String convertToJsonString(Component component) {
        return (String)GSON_COMPONENT_SERIALIZER.serialize(component);
    }

    public static Component convertJsonToComponent(String messageJson) {
        return GSON_COMPONENT_SERIALIZER.deserialize(messageJson);
    }

    public static String convertToPlain(Component component) {
        return PLAIN_COMPONENT_SERIALIZER.serialize(component);
    }

    public static void sendException(Throwable t, SRCommandSender sender, SkinsRestorerLocale locale, SRLogger logger) {
        if (t instanceof TranslatableException) {
            sender.sendMessage(((TranslatableException)((Object)t)).getMessage(sender, locale));
        } else {
            sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(locale.getMessage(sender, Message.ERROR_GENERIC, Placeholder.unparsed("message", SRHelpers.getRootCause(t).getMessage()))));
            logger.warning("An error occurred while executing a command", t);
        }
    }
}

