/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> builtInMap = new HashMap();

    private ReflectionUtil() {
    }

    public static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean classExists(String ... classNames) {
        for (String className : classNames) {
            if (!ReflectionUtil.classExists(className)) continue;
            return true;
        }
        return false;
    }

    public static Enum<?> getEnum(Class<?> clazz, String constant) throws ReflectiveOperationException {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(constant)) continue;
            return e;
        }
        throw new ReflectiveOperationException(String.format("Enum constant not found %s", constant));
    }

    public static Enum<?> getEnum(Class<?> clazz, int ordinal) throws ReflectiveOperationException {
        try {
            return (Enum)clazz.getEnumConstants()[ordinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ReflectiveOperationException(String.format("Enum constant not found %s", ordinal));
        }
    }

    public static Enum<?> getEnum(Class<?> clazz, String enumName, String constant) throws ReflectiveOperationException {
        return ReflectionUtil.getEnum(ReflectionUtil.getSubClass(clazz, enumName), constant);
    }

    private static Class<?> getSubClass(Class<?> clazz, String className) throws ReflectiveOperationException {
        for (Class<?> subClass : clazz.getDeclaredClasses()) {
            if (!subClass.getSimpleName().equals(className)) continue;
            return subClass;
        }
        for (Class<?> subClass : clazz.getClasses()) {
            if (!subClass.getSimpleName().equals(className)) continue;
            return subClass;
        }
        throw new ClassNotFoundException("Sub class " + className + " of " + clazz.getSimpleName() + " not found!");
    }

    public static Field getField(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        Field f;
        try {
            f = clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            f = clazz.getField(fieldName);
        }
        f.setAccessible(true);
        return f;
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws ReflectiveOperationException {
        Method m;
        try {
            m = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            m = clazz.getMethod(methodName, new Class[0]);
        }
        m.setAccessible(true);
        return m;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) throws ReflectiveOperationException {
        Method m;
        try {
            m = clazz.getDeclaredMethod(methodName, args);
        }
        catch (Exception e) {
            m = clazz.getMethod(methodName, args);
        }
        m.setAccessible(true);
        return m;
    }

    public static <T> T getObject(Object obj, String fieldName, Class<T> tClass) throws ReflectiveOperationException {
        return tClass.cast(ReflectionUtil.getField(obj.getClass(), fieldName).get(obj));
    }

    public static Object getFieldByType(Object obj, String typeName) throws ReflectiveOperationException {
        return ReflectionUtil.getFieldByType(obj, obj.getClass(), typeName);
    }

    private static Object getFieldByType(Object obj, Class<?> superClass, String typeName) throws ReflectiveOperationException {
        return ReflectionUtil.getFieldByTypeList(obj, superClass, typeName).get(0);
    }

    public static List<Object> getFieldByTypeList(Object obj, String typeName) throws ReflectiveOperationException {
        return ReflectionUtil.getFieldByTypeList(obj, obj.getClass(), typeName);
    }

    private static List<Object> getFieldByTypeList(Object obj, Class<?> superClass, String typeName) throws ReflectiveOperationException {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Field f : superClass.getDeclaredFields()) {
            if (!f.getType().getSimpleName().equalsIgnoreCase(typeName)) continue;
            f.setAccessible(true);
            fields.add(f.get(obj));
        }
        if (superClass.getSuperclass() != null) {
            fields.addAll(ReflectionUtil.getFieldByTypeList(obj, superClass.getSuperclass(), typeName));
        }
        if (fields.isEmpty() && obj.getClass() == superClass) {
            throw new ReflectiveOperationException("Could not find field of type " + typeName + " in " + obj.getClass().getSimpleName());
        }
        return fields;
    }

    public static Object invokeConstructor(Class<?> clazz, Class<?>[] args, Object ... initArgs) throws ReflectiveOperationException {
        return ReflectionUtil.getConstructor(clazz, args).newInstance(initArgs);
    }

    public static Object invokeConstructor(Class<?> clazz, Object ... initArgs) throws ReflectiveOperationException {
        return ReflectionUtil.getConstructorByArgs(clazz, initArgs).newInstance(initArgs);
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... args) throws ReflectiveOperationException {
        Constructor<?> c = clazz.getConstructor(args);
        c.setAccessible(true);
        return c;
    }

    private static Constructor<?> getConstructorByArgs(Class<?> clazz, Object ... args) throws ReflectiveOperationException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != args.length) continue;
            int i = 0;
            for (Class<?> parameter : constructor.getParameterTypes()) {
                if (!ReflectionUtil.isAssignable(parameter, args[i])) break;
                ++i;
            }
            if (i != args.length) continue;
            return constructor;
        }
        String argsString = Arrays.stream(args).map(s -> s == null ? "null" : s.getClass().getSimpleName()).collect(Collectors.joining(", "));
        throw new ReflectiveOperationException(String.format("Could not find constructor with args %s in %s", argsString, clazz.getSimpleName()));
    }

    private static boolean isAssignable(Class<?> clazz, Object obj) {
        return (clazz = ReflectionUtil.convertToPrimitive(clazz)).isInstance(obj) || clazz == ReflectionUtil.convertToPrimitive(obj.getClass());
    }

    private static Class<?> convertToPrimitive(Class<?> clazz) {
        return builtInMap.getOrDefault(clazz, clazz);
    }

    public static Object invokeMethod(Class<?> clazz, Object obj, String method) throws ReflectiveOperationException {
        return Objects.requireNonNull(ReflectionUtil.getMethod(clazz, method)).invoke(obj, new Object[0]);
    }

    public static Object invokeMethod(Class<?> clazz, Object obj, String method, Class<?>[] args, Object ... initArgs) throws ReflectiveOperationException {
        return Objects.requireNonNull(ReflectionUtil.getMethod(clazz, method, args)).invoke(obj, initArgs);
    }

    public static Object invokeMethod(Object obj, String method) throws ReflectiveOperationException {
        return Objects.requireNonNull(ReflectionUtil.getMethod(obj.getClass(), method)).invoke(obj, new Object[0]);
    }

    static {
        builtInMap.put(Integer.class, Integer.TYPE);
        builtInMap.put(Long.class, Long.TYPE);
        builtInMap.put(Double.class, Double.TYPE);
        builtInMap.put(Float.class, Float.TYPE);
        builtInMap.put(Boolean.class, Boolean.TYPE);
        builtInMap.put(Character.class, Character.TYPE);
        builtInMap.put(Byte.class, Byte.TYPE);
        builtInMap.put(Short.class, Short.TYPE);
    }
}

