/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SRHelpers {
    private SRHelpers() {
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return SRHelpers.getRootCause(throwable.getCause());
        }
        return throwable;
    }

    public static long hashSha256String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return ByteBuffer.wrap(digest).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get SHA-256 hash algorithm", e);
        }
    }
}

