/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.nio.file.Path;
import net.skinsrestorer.shared.plugin.SRBootstrapper;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.sponge.SRSpongeAdapter;
import net.skinsrestorer.sponge.SRSpongeInit;
import net.skinsrestorer.sponge.logger.Log4jLoggerImpl;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.ConstructPluginEvent;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="skinsrestorer")
public class SRSpongeBootstrap {
    @Inject
    private PluginContainer container;
    @ConfigDir(sharedRoot=false)
    @Inject
    private Path dataFolder;
    @Inject
    private Injector guiceInjector;
    @Inject
    private Logger logger;
    @Inject
    private Game game;
    @Inject
    private MetricsConfigManager metricsConfigManager;

    @Listener
    public void onInitialize(ConstructPluginEvent event) {
        SRBootstrapper.startPlugin(runnable -> {}, injector -> {
            injector.register(Game.class, this.game);
            injector.register(PluginContainer.class, this.container);
            injector.register(Injector.class, this.guiceInjector);
            injector.register(MetricsConfigManager.class, this.metricsConfigManager);
        }, new Log4jLoggerImpl(this.logger), false, SRSpongeAdapter.class, SRServerPlugin.class, this.container.metadata().version().toString(), this.dataFolder, SRSpongeInit.class);
    }
}

