/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.sponge.SRSpongeAdapter;
import net.skinsrestorer.sponge.SkinApplierSponge;
import net.skinsrestorer.sponge.listeners.LoginListener;
import net.skinsrestorer.sponge.listeners.MetricsJoinListener;
import net.skinsrestorer.sponge.listeners.ServerMessageListener;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;
import org.spongepowered.api.service.permission.PermissionDescription;

public class SRSpongeInit
implements SRServerPlatformInit {
    private static final GsonComponentSerializer GSON = GsonComponentSerializer.gson();
    private final Injector injector;
    private final SRSpongeAdapter adapter;
    private final SRPlugin plugin;
    private final Game game;
    private final WrapperSponge wrapper;
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;

    @Override
    public void initSkinApplier() {
        this.plugin.registerSkinApplier(this.injector.getSingleton(SkinApplierSponge.class), ServerPlayer.class, this.wrapper::player);
    }

    @Override
    public void initLoginProfileListener() {
        this.game.eventManager().registerListener(EventListenerRegistration.builder(ServerSideConnectionEvent.Auth.class).plugin(this.adapter.getPluginContainer()).order(Order.DEFAULT).listener((EventListener)this.injector.newInstance(LoginListener.class)).build());
    }

    @Override
    public void initMetricsJoinListener() {
        this.logger.info("Dear server admin, in order to help us decide whether we should continue supporting Sponge for SkinsRestorer, consider enabling metrics by executing /sponge metrics skinsrestorer enable");
        this.game.eventManager().registerListener(EventListenerRegistration.builder(ServerSideConnectionEvent.Join.class).plugin(this.adapter.getPluginContainer()).order(Order.DEFAULT).listener((EventListener)this.injector.newInstance(MetricsJoinListener.class)).build());
    }

    @Override
    public void initPermissions() {
        this.game.eventManager().registerListeners(this.adapter.getPluginContainer(), (Object)this);
    }

    @Override
    public void initGUIListener() {
    }

    @Override
    public void initMessageChannel() {
        ((RawDataChannel)this.game.channelManager().ofType(ResourceKey.of((String)"sr", (String)"messagechannel"), RawDataChannel.class)).play().addHandler((RawPlayDataHandler)this.injector.newInstance(ServerMessageListener.class));
    }

    @Listener
    public void onEngineStarting(StartingEngineEvent<Server> event) {
        for (PermissionRegistry permissionRegistry : PermissionRegistry.values()) {
            this.newDescriptionBuilder(permissionRegistry.getPermission(), permissionRegistry.getDescription()).register();
        }
        for (Enum enum_ : PermissionGroup.values()) {
            String groupString = enum_ == PermissionGroup.PLAYER ? "user" : "staff";
            this.newDescriptionBuilder(((PermissionGroup)enum_).getBasePermission(), ((PermissionGroup)enum_).getDescription()).assign(groupString, true).register();
        }
    }

    private PermissionDescription.Builder newDescriptionBuilder(Permission permission, Message description) {
        return this.game.server().serviceProvider().permissionService().newDescriptionBuilder(this.adapter.getPluginContainer()).id(permission.getPermissionString()).description(GSON.deserialize((Object)this.locale.getMessage(this.locale.getDefaultForeign(), description)));
    }

    @Inject
    public SRSpongeInit(Injector injector, SRSpongeAdapter adapter, SRPlugin plugin, Game game, WrapperSponge wrapper, SkinsRestorerLocale locale, SRLogger logger) {
        this.injector = injector;
        this.adapter = adapter;
        this.plugin = plugin;
        this.game = game;
        this.wrapper = wrapper;
        this.locale = locale;
        this.logger = logger;
    }
}

