/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import net.kyori.adventure.text.Component;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.sponge.SRSpongeAdapter;
import org.spongepowered.api.Game;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;

public class SkinApplierSponge
implements SkinApplierAccess<ServerPlayer> {
    private final SRSpongeAdapter plugin;
    private final Game game;

    @Override
    public void applySkin(ServerPlayer player, SkinProperty property) {
        try {
            GameProfile gameProfile = (GameProfile)ReflectionUtil.invokeMethod(player, "getGameProfile");
            gameProfile.getProperties().removeAll((Object)"textures");
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        this.plugin.runSync(() -> this.sendUpdate(player));
    }

    private void sendUpdate(ServerPlayer receiver) {
        receiver.tabList().removeEntry(receiver.uniqueId());
        receiver.tabList().addEntry(TabListEntry.builder().displayName((Component)receiver.displayName().get()).latency(receiver.connection().latency()).list(receiver.tabList()).gameMode((GameMode)receiver.gameMode().get()).profile(receiver.profile()).build());
        ServerLocation loc = receiver.serverLocation();
        Vector3d rotation = receiver.rotation();
        for (ServerWorld serverWorld : this.game.server().worldManager().worlds()) {
            if (serverWorld.uniqueId().equals(receiver.world().uniqueId())) continue;
            receiver.setLocation((ServerLocation)serverWorld.location(serverWorld.properties().spawnPosition()));
            receiver.setLocationAndRotation(loc, rotation);
            break;
        }
        receiver.offer(Keys.VANISH_STATE, (Object)VanishState.vanished());
        this.game.server().scheduler().executor(this.plugin.getPluginContainer()).execute(() -> receiver.offer(Keys.VANISH_STATE, (Object)VanishState.unvanished()));
    }

    @Inject
    public SkinApplierSponge(SRSpongeAdapter plugin, Game game) {
        this.plugin = plugin;
        this.game = game;
    }
}

