/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.gui;

import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.menu.ClickType;
import org.spongepowered.api.item.inventory.menu.handler.SlotClickHandler;

public class GUIListener
implements SlotClickHandler {
    private final Consumer<ClickEventInfo> callback;
    private final int page;
    private final WrapperSponge wrapper;

    public boolean handle(Cause cause, Container container, Slot slot, int slotIndex, ClickType<?> clickType) {
        Optional player = cause.first(ServerPlayer.class);
        if (!player.isPresent()) {
            return false;
        }
        ItemStack stack = slot.peek();
        if (stack == ItemStack.empty()) {
            return false;
        }
        Optional displayName = stack.getValue(Keys.CUSTOM_NAME);
        if (!displayName.isPresent()) {
            return false;
        }
        this.callback.accept(new ClickEventInfo(this.getMaterialType(stack), PlainTextComponentSerializer.plainText().serialize((Component)((Value)displayName.get()).get()), this.wrapper.player((ServerPlayer)player.get()), this.page));
        return false;
    }

    private ClickEventInfo.MaterialType getMaterialType(ItemStack stack) {
        ItemType type = stack.type();
        if (type == ItemTypes.PLAYER_HEAD.get()) {
            return ClickEventInfo.MaterialType.HEAD;
        }
        if (type == ItemTypes.YELLOW_STAINED_GLASS_PANE.get()) {
            return ClickEventInfo.MaterialType.YELLOW_PANE;
        }
        if (type == ItemTypes.GREEN_STAINED_GLASS_PANE.get()) {
            return ClickEventInfo.MaterialType.GREEN_PANE;
        }
        if (type == ItemTypes.RED_STAINED_GLASS_PANE.get()) {
            return ClickEventInfo.MaterialType.RED_PANE;
        }
        return ClickEventInfo.MaterialType.UNKNOWN;
    }

    public GUIListener(Consumer<ClickEventInfo> callback, int page, WrapperSponge wrapper) {
        this.callback = callback;
        this.page = page;
        this.wrapper = wrapper;
    }
}

