/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.gui;

import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.gui.GUIManager;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.FluentList;
import net.skinsrestorer.sponge.SRSpongeAdapter;
import net.skinsrestorer.sponge.gui.GUIListener;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ContainerTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.api.item.inventory.menu.handler.SlotClickHandler;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SkinsGUI
implements GUIManager<InventoryMenu> {
    private static final GsonComponentSerializer GSON = GsonComponentSerializer.gson();
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;
    private final SRSpongeAdapter adapter;
    private final WrapperSponge wrapper;

    private static ItemStack createSkull(SkinsRestorerLocale locale, SRForeign player, String name, String property) {
        return ((ItemStack.Builder)((ItemStack.Builder)((ItemStack.Builder)ItemStack.builder().itemType((Supplier)ItemTypes.PLAYER_HEAD).add(Keys.LORE, FluentList.of(GSON.deserialize((Object)locale.getMessage(player, Message.SKINSMENU_SELECT_SKIN))))).add(Keys.GAME_PROFILE, (Object)GameProfile.of((UUID)UUID.randomUUID(), null).withProperty(ProfileProperty.of((String)"textures", (String)property)))).add(Keys.CUSTOM_NAME, (Object)Component.text((String)name))).build();
    }

    private static ItemStack createGlass(GlassType type, SRForeign player, SkinsRestorerLocale locale) {
        return ((ItemStack.Builder)ItemStack.builder().itemType(type.getMaterial()).add(Keys.CUSTOM_NAME, type.getMessage() == null ? Component.text((String)" ") : GSON.deserialize((Object)locale.getMessage(player, type.getMessage())))).build();
    }

    @Override
    public InventoryMenu createGUI(Consumer<ClickEventInfo> callback, SRForeign player, int page, Map<String, String> skinsList) {
        ViewableInventory inventory = ViewableInventory.builder().type((Supplier)ContainerTypes.GENERIC_9X6).completeStructure().plugin(this.adapter.getPluginContainer()).build();
        ItemStack none = SkinsGUI.createGlass(GlassType.NONE, player, this.locale);
        ItemStack delete = SkinsGUI.createGlass(GlassType.DELETE, player, this.locale);
        ItemStack prev = SkinsGUI.createGlass(GlassType.PREV, player, this.locale);
        ItemStack next = SkinsGUI.createGlass(GlassType.NEXT, player, this.locale);
        int skinCount = 0;
        for (Map.Entry<String, String> entry : skinsList.entrySet()) {
            if (skinCount >= 36) {
                this.logger.warning("SkinsGUI: Skin count is more than 36, skipping...");
                break;
            }
            inventory.set(skinCount, SkinsGUI.createSkull(this.locale, player, entry.getKey(), entry.getValue()));
            ++skinCount;
        }
        inventory.set(36, none);
        inventory.set(37, none);
        inventory.set(38, none);
        inventory.set(39, none);
        inventory.set(40, none);
        inventory.set(41, none);
        inventory.set(42, none);
        inventory.set(43, none);
        inventory.set(44, none);
        if (page > 0) {
            inventory.set(45, prev);
            inventory.set(46, prev);
            inventory.set(47, prev);
        } else {
            inventory.set(45, none);
            inventory.set(46, none);
            inventory.set(47, none);
        }
        inventory.set(48, delete);
        inventory.set(49, delete);
        inventory.set(50, delete);
        if (page < 999 && skinCount <= 36) {
            inventory.set(51, next);
            inventory.set(52, next);
            inventory.set(53, next);
        } else {
            inventory.set(51, none);
            inventory.set(52, none);
            inventory.set(53, none);
        }
        InventoryMenu menu = inventory.asMenu();
        menu.setTitle(GSON.deserialize((Object)this.locale.getMessage(player, Message.SKINSMENU_TITLE_NEW, new TagResolver[]{Placeholder.unparsed((String)"page_number", (String)String.valueOf(page + 1))})));
        menu.setReadOnly(true);
        menu.registerSlotClick((SlotClickHandler)new GUIListener(callback, page, this.wrapper));
        return menu;
    }

    @Inject
    public SkinsGUI(SkinsRestorerLocale locale, SRLogger logger, SRSpongeAdapter adapter, WrapperSponge wrapper) {
        this.locale = locale;
        this.logger = logger;
        this.adapter = adapter;
        this.wrapper = wrapper;
    }

    private static enum GlassType {
        NONE((ItemType)ItemTypes.WHITE_STAINED_GLASS_PANE.get(), null),
        PREV((ItemType)ItemTypes.YELLOW_STAINED_GLASS_PANE.get(), Message.SKINSMENU_PREVIOUS_PAGE),
        NEXT((ItemType)ItemTypes.GREEN_STAINED_GLASS.get(), Message.SKINSMENU_NEXT_PAGE),
        DELETE((ItemType)ItemTypes.RED_STAINED_GLASS_PANE.get(), Message.SKINSMENU_CLEAR_SKIN);

        private final ItemType material;
        private final Message message;

        public ItemType getMaterial() {
            return this.material;
        }

        public Message getMessage() {
            return this.message;
        }

        private GlassType(ItemType material, Message message) {
            this.material = material;
            this.message = message;
        }
    }
}

