/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.listeners;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.listeners.LoginProfileListenerAdapter;
import net.skinsrestorer.shared.listeners.event.SRLoginProfileEvent;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;

public class LoginListener
implements EventListener<ServerSideConnectionEvent.Auth> {
    private final LoginProfileListenerAdapter<Void> adapter;

    public void handle(@NotNull ServerSideConnectionEvent.Auth event) {
        try {
            this.adapter.handleLogin(this.wrap(event));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private SRLoginProfileEvent<Void> wrap(final ServerSideConnectionEvent.Auth event) {
        return new SRLoginProfileEvent<Void>(){

            @Override
            public boolean hasOnlineProperties() {
                return event.profile().properties().stream().anyMatch(p -> p.name().equals("textures"));
            }

            @Override
            public UUID getPlayerUniqueId() {
                return event.profile().uniqueId();
            }

            @Override
            public String getPlayerName() {
                return (String)event.profile().name().orElseThrow(() -> new RuntimeException("Could not get player name!"));
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void setResultProperty(SkinProperty property) {
                try {
                    GameProfile gameProfile = (GameProfile)ReflectionUtil.getFieldByType(event.connection(), "GameProfile");
                    gameProfile.getProperties().removeAll((Object)"textures");
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Void runAsync(Runnable runnable) {
                runnable.run();
                return null;
            }
        };
    }

    @Inject
    public LoginListener(LoginProfileListenerAdapter<Void> adapter) {
        this.adapter = adapter;
    }
}

