/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.listeners;

import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.listeners.SRServerMessageAdapter;
import net.skinsrestorer.shared.listeners.event.SRServerMessageEvent;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.sponge.wrapper.WrapperSponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;

public class ServerMessageListener
implements RawPlayDataHandler<EngineConnection> {
    private final SRServerMessageAdapter adapter;
    private final WrapperSponge wrapper;

    public void handlePayload(ChannelBuf data, EngineConnection connection) {
        if (!(connection instanceof ServerPlayerConnection)) {
            return;
        }
        this.adapter.handlePluginMessage(this.wrap(data, (ServerPlayerConnection)connection));
    }

    private SRServerMessageEvent wrap(final ChannelBuf data, final ServerPlayerConnection player) {
        return new SRServerMessageEvent(){

            @Override
            public SRPlayer getPlayer() {
                return ServerMessageListener.this.wrapper.player(player.player());
            }

            @Override
            public byte[] getData() {
                byte[] result = new byte[data.available()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = data.readByte();
                }
                return result;
            }

            @Override
            public String getChannel() {
                return "sr:messagechannel";
            }
        };
    }

    @Inject
    public ServerMessageListener(SRServerMessageAdapter adapter, WrapperSponge wrapper) {
        this.adapter = adapter;
        this.wrapper = wrapper;
    }
}

