/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.wrapper;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shared.subjects.AbstractSRCommandSender;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.utils.Tristate;
import org.spongepowered.api.service.permission.Subject;

public class WrapperCommandSender
extends AbstractSRCommandSender {
    private final SettingsManager settings;
    private final SkinsRestorerLocale locale;
    private final Subject subject;
    private final Audience audience;
    private final GsonComponentSerializer serializer = GsonComponentSerializer.gson();

    @Override
    public void sendMessage(String messageJson) {
        this.audience.sendMessage(this.serializer.deserialize((Object)messageJson));
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return permission.checkPermission(this.settings, p -> {
            switch (this.subject.permissionValue(p)) {
                case TRUE: {
                    return Tristate.TRUE;
                }
                case FALSE: {
                    return Tristate.FALSE;
                }
            }
            return Tristate.UNDEFINED;
        });
    }

    @Override
    protected SkinsRestorerLocale getSRLocale() {
        return this.locale;
    }

    @Override
    protected SettingsManager getSettings() {
        return this.settings;
    }

    protected WrapperCommandSender(WrapperCommandSenderBuilder<?, ?> b) {
        super(b);
        this.settings = b.settings;
        this.locale = b.locale;
        this.subject = b.subject;
        this.audience = b.audience;
    }

    public static WrapperCommandSenderBuilder<?, ?> builder() {
        return new WrapperCommandSenderBuilderImpl();
    }

    public static abstract class WrapperCommandSenderBuilder<C extends WrapperCommandSender, B extends WrapperCommandSenderBuilder<C, B>>
    extends AbstractSRCommandSender.AbstractSRCommandSenderBuilder<C, B> {
        private SettingsManager settings;
        private SkinsRestorerLocale locale;
        private Subject subject;
        private Audience audience;

        public B settings(SettingsManager settings) {
            this.settings = settings;
            return (B)this.self();
        }

        public B locale(SkinsRestorerLocale locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B subject(Subject subject) {
            this.subject = subject;
            return (B)this.self();
        }

        public B audience(Audience audience) {
            this.audience = audience;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperCommandSender.WrapperCommandSenderBuilder(super=" + super.toString() + ", settings=" + this.settings + ", locale=" + this.locale + ", subject=" + this.subject + ", audience=" + this.audience + ")";
        }
    }

    private static final class WrapperCommandSenderBuilderImpl
    extends WrapperCommandSenderBuilder<WrapperCommandSender, WrapperCommandSenderBuilderImpl> {
        private WrapperCommandSenderBuilderImpl() {
        }

        @Override
        protected WrapperCommandSenderBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperCommandSender build() {
            return new WrapperCommandSender(this);
        }
    }
}

