/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.velocity.wrapper.WrapperVelocity;

public class SkinApplierVelocity
implements SkinApplierAccess<Player> {
    private final SettingsManager settings;
    private final WrapperVelocity wrapper;
    private final SRProxyPlugin proxyPlugin;
    private final EventBusImpl eventBus;

    @Override
    public void applySkin(Player player, SkinProperty property) {
        SkinApplyEventImpl applyEvent = new SkinApplyEventImpl(player, property);
        this.eventBus.callEvent(applyEvent);
        if (applyEvent.isCancelled()) {
            return;
        }
        SkinProperty appliedProperty = applyEvent.getProperty();
        player.setGameProfileProperties(this.updatePropertiesSkin(player.getGameProfileProperties(), appliedProperty));
        this.proxyPlugin.sendUpdateRequest(this.wrapper.player(player), this.settings.getProperty(AdvancedConfig.FORWARD_TEXTURES) != false ? appliedProperty : null);
    }

    public GameProfile updateProfileSkin(GameProfile profile, SkinProperty property) {
        return new GameProfile(profile.getId(), profile.getName(), this.updatePropertiesSkin(profile.getProperties(), property));
    }

    private List<GameProfile.Property> updatePropertiesSkin(List<GameProfile.Property> original, SkinProperty property) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(original);
        properties.removeIf(property1 -> property1.getName().equals("textures"));
        properties.add(new GameProfile.Property("textures", property.getValue(), property.getSignature()));
        return properties;
    }

    @Inject
    public SkinApplierVelocity(SettingsManager settings, WrapperVelocity wrapper, SRProxyPlugin proxyPlugin, EventBusImpl eventBus) {
        this.settings = settings;
        this.wrapper = wrapper;
        this.proxyPlugin = proxyPlugin;
        this.eventBus = eventBus;
    }
}

