/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.wrapper;

import com.velocitypowered.api.command.CommandSource;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shared.subjects.AbstractSRCommandSender;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.utils.Tristate;

public class WrapperCommandSender
extends AbstractSRCommandSender {
    private final SettingsManager settings;
    private final SkinsRestorerLocale locale;
    private final CommandSource sender;
    private final GsonComponentSerializer serializer = GsonComponentSerializer.gson();

    @Override
    public void sendMessage(String messageJson) {
        this.sender.sendMessage(this.serializer.deserialize((Object)messageJson));
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return permission.checkPermission(this.settings, p -> {
            switch (this.sender.getPermissionValue(p)) {
                case TRUE: {
                    return Tristate.TRUE;
                }
                case FALSE: {
                    return Tristate.FALSE;
                }
            }
            return Tristate.UNDEFINED;
        });
    }

    @Override
    protected SkinsRestorerLocale getSRLocale() {
        return this.locale;
    }

    @Override
    protected SettingsManager getSettings() {
        return this.settings;
    }

    protected WrapperCommandSender(WrapperCommandSenderBuilder<?, ?> b) {
        super(b);
        this.settings = b.settings;
        this.locale = b.locale;
        this.sender = b.sender;
    }

    public static WrapperCommandSenderBuilder<?, ?> builder() {
        return new WrapperCommandSenderBuilderImpl();
    }

    public static abstract class WrapperCommandSenderBuilder<C extends WrapperCommandSender, B extends WrapperCommandSenderBuilder<C, B>>
    extends AbstractSRCommandSender.AbstractSRCommandSenderBuilder<C, B> {
        private SettingsManager settings;
        private SkinsRestorerLocale locale;
        private CommandSource sender;

        public B settings(SettingsManager settings) {
            this.settings = settings;
            return (B)this.self();
        }

        public B locale(SkinsRestorerLocale locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B sender(CommandSource sender) {
            this.sender = sender;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperCommandSender.WrapperCommandSenderBuilder(super=" + super.toString() + ", settings=" + this.settings + ", locale=" + this.locale + ", sender=" + this.sender + ")";
        }
    }

    private static final class WrapperCommandSenderBuilderImpl
    extends WrapperCommandSenderBuilder<WrapperCommandSender, WrapperCommandSenderBuilderImpl> {
        private WrapperCommandSenderBuilderImpl() {
        }

        @Override
        protected WrapperCommandSenderBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperCommandSender build() {
            return new WrapperCommandSender(this);
        }
    }
}

