/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.wrapper;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.velocity.wrapper.WrapperCommandSender;

public class WrapperPlayer
extends WrapperCommandSender
implements SRProxyPlayer {
    private final Player player;

    @Override
    public Locale getLocale() {
        Locale playerLocale = this.player.getEffectiveLocale();
        if (playerLocale == null) {
            return super.getLocale();
        }
        return playerLocale;
    }

    @Override
    public String getName() {
        return this.player.getUsername();
    }

    @Override
    public <P> P getAs(Class<P> playerClass) {
        return playerClass.cast(this.player);
    }

    @Override
    public Optional<String> getCurrentServer() {
        return this.player.getCurrentServer().map(server -> server.getServerInfo().getName());
    }

    @Override
    public void sendDataToServer(String channel, byte[] data) {
        this.player.getCurrentServer().map(server -> server.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)channel), data));
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return true;
    }

    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = b.player;
    }

    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        private Player player;

        public B player(Player player) {
            this.player = player;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + super.toString() + ", player=" + this.player + ")";
        }
    }

    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        private WrapperPlayerBuilderImpl() {
        }

        @Override
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

