/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import java.util.Collection;
import java.util.Collections;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.Preconditions;

public class PacketPlayOutScoreboardTeam
implements TabPacket {
    private final String name;
    private String playerPrefix;
    private String playerSuffix;
    private String nameTagVisibility;
    private String collisionRule;
    private EnumChatFormat color;
    private Collection<String> players = Collections.emptyList();
    private final int action;
    private int options;

    private PacketPlayOutScoreboardTeam(int action, String name) {
        Preconditions.checkNotNull(name, "team name");
        Preconditions.checkMaxLength(name, 16, "team name");
        this.action = action;
        this.name = name;
    }

    public PacketPlayOutScoreboardTeam(String team, String prefix, String suffix, String visibility, String collision, Collection<String> players, int options) {
        this(0, team);
        Preconditions.checkNotNull(prefix, "prefix");
        Preconditions.checkNotNull(suffix, "suffix");
        Preconditions.checkNotNull(visibility, "visibility");
        Preconditions.checkNotNull(collision, "collision");
        Preconditions.checkNotNull(players, "players");
        this.playerPrefix = prefix;
        this.playerSuffix = suffix;
        this.nameTagVisibility = visibility;
        this.collisionRule = collision;
        this.players = players;
        this.options = options;
    }

    public PacketPlayOutScoreboardTeam(String team) {
        this(1, team);
    }

    public PacketPlayOutScoreboardTeam(String team, String prefix, String suffix, String visibility, String collision, int options) {
        this(2, team);
        Preconditions.checkNotNull(prefix, "prefix");
        Preconditions.checkNotNull(suffix, "suffix");
        Preconditions.checkNotNull(visibility, "visibility");
        Preconditions.checkNotNull(collision, "collision");
        Preconditions.checkNotNull(this.players, "players");
        this.playerPrefix = prefix;
        this.playerSuffix = suffix;
        this.nameTagVisibility = visibility;
        this.collisionRule = collision;
        this.options = options;
    }

    public PacketPlayOutScoreboardTeam(String team, Collection<String> players, boolean add) {
        this(add ? 3 : 4, team);
        Preconditions.checkNotNull(players, "players");
        this.players = players;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutScoreboardTeam{name=%s,playerPrefix=%s,playerSuffix=%s,nameTagVisibility=%s,collisionRule=%s,color=%s,players=%s,method=%s,options=%s}", new Object[]{this.name, this.playerPrefix, this.playerSuffix, this.nameTagVisibility, this.collisionRule, this.color, this.players, this.action, this.options});
    }

    public String getName() {
        return this.name;
    }

    public String getPlayerPrefix() {
        return this.playerPrefix;
    }

    public String getPlayerSuffix() {
        return this.playerSuffix;
    }

    public String getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    public String getCollisionRule() {
        return this.collisionRule;
    }

    public void setColor(EnumChatFormat color) {
        this.color = color;
    }

    public EnumChatFormat getColor() {
        return this.color;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public int getOptions() {
        return this.options;
    }

    public int getAction() {
        return this.action;
    }
}

