/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.chat.WrappedChatComponent;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.Skin;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityDestroy;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityMetadata;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityTeleport;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutSpawnEntityLiving;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

public class BukkitPacketBuilder
extends PacketBuilder {
    private final NMSStorage nms = NMSStorage.getInstance();
    private final EnumMap<EntityType, Integer> entityIds = new EnumMap(EntityType.class);
    private final Map<IChatBaseComponent, Object> componentCacheModern = new HashMap<IChatBaseComponent, Object>();
    private final Map<IChatBaseComponent, Object> componentCacheLegacy = new HashMap<IChatBaseComponent, Object>();

    public BukkitPacketBuilder() {
        if (this.nms.getMinorVersion() >= 19) {
            this.entityIds.put(EntityType.ARMOR_STAND, 2);
        } else if (this.nms.getMinorVersion() >= 13) {
            this.entityIds.put(EntityType.ARMOR_STAND, 1);
        } else {
            this.entityIds.put(EntityType.WITHER, 64);
            if (this.nms.getMinorVersion() >= 8) {
                this.entityIds.put(EntityType.ARMOR_STAND, 30);
            }
        }
        this.buildMap.put(PacketPlayOutEntityMetadata.class, (packet, version) -> this.build((PacketPlayOutEntityMetadata)packet));
        this.buildMap.put(PacketPlayOutEntityTeleport.class, (packet, version) -> this.build((PacketPlayOutEntityTeleport)packet));
        this.buildMap.put(PacketPlayOutEntityDestroy.class, (packet, version) -> this.build((PacketPlayOutEntityDestroy)packet));
        this.buildMap.put(PacketPlayOutSpawnEntityLiving.class, (packet, version) -> this.build((PacketPlayOutSpawnEntityLiving)packet));
    }

    @Override
    public Object build(PacketPlayOutBoss packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 9 || clientVersion.getMinorVersion() >= 9) {
            return packet;
        }
        return this.buildBossPacketEntity(packet, clientVersion);
    }

    @Override
    public Object build(PacketPlayOutChat packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        Object component = this.toNMSComponent(packet.getMessage(), clientVersion);
        if (this.nms.getMinorVersion() >= 19) {
            try {
                return this.nms.newPacketPlayOutChat.newInstance(component, packet.getType() == PacketPlayOutChat.ChatMessageType.GAME_INFO);
            }
            catch (Exception e) {
                return this.nms.newPacketPlayOutChat.newInstance(component, packet.getType().ordinal());
            }
        }
        if (this.nms.getMinorVersion() >= 16) {
            return this.nms.newPacketPlayOutChat.newInstance(component, this.nms.ChatMessageType_values[packet.getType().ordinal()], UUID.randomUUID());
        }
        if (this.nms.getMinorVersion() >= 12) {
            return this.nms.newPacketPlayOutChat.newInstance(component, Enum.valueOf(this.nms.ChatMessageType, packet.getType().toString()));
        }
        if (this.nms.getMinorVersion() >= 8) {
            return this.nms.newPacketPlayOutChat.newInstance(component, (byte)packet.getType().ordinal());
        }
        if (this.nms.getMinorVersion() == 7) {
            return this.nms.newPacketPlayOutChat.newInstance(component);
        }
        return packet;
    }

    @Override
    public Object build(PacketPlayOutPlayerInfo packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        Object nmsPacket = this.nms.newPacketPlayOutPlayerInfo.newInstance(this.nms.EnumPlayerInfoAction_values[packet.getAction().ordinal()], Array.newInstance(this.nms.EntityPlayer, 0));
        ArrayList items = new ArrayList();
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            GameProfile profile = new GameProfile(data.getUniqueId(), data.getName());
            if (data.getSkin() != null) {
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", data.getSkin().getValue(), data.getSkin().getSignature()));
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            if (this.nms.newPlayerInfoData.getParameterTypes()[0] == this.nms.PacketPlayOutPlayerInfo) {
                parameters.add(nmsPacket);
            }
            parameters.add(profile);
            parameters.add(data.getLatency());
            parameters.add(data.getGameMode() == null ? null : this.nms.EnumGamemode_values[this.nms.EnumGamemode_values.length - PacketPlayOutPlayerInfo.EnumGamemode.VALUES.length + data.getGameMode().ordinal()]);
            parameters.add(data.getDisplayName() == null ? null : this.toNMSComponent(data.getDisplayName(), clientVersion));
            if (this.nms.getMinorVersion() >= 19) {
                parameters.add(data.getProfilePublicKey());
            }
            items.add(this.nms.newPlayerInfoData.newInstance(parameters.toArray()));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerInfo_PLAYERS, items);
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutPlayerListHeaderFooter packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        if (this.nms.newPacketPlayOutPlayerListHeaderFooter.getParameterCount() == 2) {
            return this.nms.newPacketPlayOutPlayerListHeaderFooter.newInstance(this.toNMSComponent(packet.getHeader(), clientVersion), this.toNMSComponent(packet.getFooter(), clientVersion));
        }
        Object nmsPacket = this.nms.newPacketPlayOutPlayerListHeaderFooter.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerListHeaderFooter_HEADER, this.toNMSComponent(packet.getHeader(), clientVersion));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerListHeaderFooter_FOOTER, this.toNMSComponent(packet.getFooter(), clientVersion));
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutScoreboardDisplayObjective packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        return this.nms.newPacketPlayOutScoreboardDisplayObjective.newInstance(packet.getSlot(), this.newScoreboardObjective(packet.getObjectiveName()));
    }

    @Override
    public Object build(PacketPlayOutScoreboardObjective packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        String displayName;
        String string = displayName = clientVersion.getMinorVersion() < 13 ? this.cutTo(packet.getDisplayName(), 32) : packet.getDisplayName();
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newPacketPlayOutScoreboardObjective.newInstance(this.nms.newScoreboardObjective.newInstance(null, packet.getObjectiveName(), null, this.toNMSComponent(IChatBaseComponent.optimizedComponent(displayName), clientVersion), packet.getRenderType() == null ? null : this.nms.EnumScoreboardHealthDisplay_values[packet.getRenderType().ordinal()]), packet.getAction());
        }
        Object nmsPacket = this.nms.newPacketPlayOutScoreboardObjective.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_OBJECTIVENAME, packet.getObjectiveName());
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_DISPLAYNAME, displayName);
        if (this.nms.getMinorVersion() >= 8 && packet.getRenderType() != null) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_RENDERTYPE, Enum.valueOf(this.nms.EnumScoreboardHealthDisplay, packet.getRenderType().toString()));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_METHOD, packet.getAction());
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutScoreboardScore packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newPacketPlayOutScoreboardScore_1_13.newInstance(this.nms.EnumScoreboardAction_values[packet.getAction().ordinal()], packet.getObjectiveName(), packet.getPlayer(), packet.getScore());
        }
        if (packet.getAction() == PacketPlayOutScoreboardScore.Action.REMOVE) {
            return this.nms.newPacketPlayOutScoreboardScore_String.newInstance(packet.getPlayer());
        }
        Object score = this.nms.newScoreboardScore.newInstance(this.nms.emptyScoreboard, this.newScoreboardObjective(packet.getObjectiveName()), packet.getPlayer());
        this.nms.ScoreboardScore_setScore.invoke(score, packet.getScore());
        if (this.nms.getMinorVersion() >= 8) {
            return this.nms.newPacketPlayOutScoreboardScore.newInstance(score);
        }
        return this.nms.newPacketPlayOutScoreboardScore.newInstance(score, 0);
    }

    @Override
    public Object build(PacketPlayOutScoreboardTeam packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.PacketPlayOutScoreboardTeam == null) {
            return null;
        }
        Object team = this.nms.newScoreboardTeam.newInstance(this.nms.emptyScoreboard, packet.getName());
        String prefix = packet.getPlayerPrefix();
        String suffix = packet.getPlayerSuffix();
        if (clientVersion.getMinorVersion() < 13) {
            prefix = this.cutTo(prefix, 16);
            suffix = this.cutTo(suffix, 16);
        }
        ((Collection)this.nms.ScoreboardTeam_getPlayerNameSet.invoke(team, new Object[0])).addAll(packet.getPlayers());
        this.nms.ScoreboardTeam_setAllowFriendlyFire.invoke(team, (packet.getOptions() & 1) > 0);
        this.nms.ScoreboardTeam_setCanSeeFriendlyInvisibles.invoke(team, (packet.getOptions() & 2) > 0);
        if (this.nms.getMinorVersion() >= 13) {
            this.createTeamModern(packet, clientVersion, team, prefix, suffix);
        } else {
            this.createTeamLegacy(packet, team, prefix, suffix);
        }
        if (this.nms.getMinorVersion() >= 17) {
            switch (packet.getAction()) {
                case 0: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofBoolean.invoke(null, team, true);
                }
                case 1: {
                    return this.nms.PacketPlayOutScoreboardTeam_of.invoke(null, team);
                }
                case 2: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofBoolean.invoke(null, team, false);
                }
                case 3: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofString.invoke(null, team, packet.getPlayers().toArray(new String[0])[0], this.nms.PacketPlayOutScoreboardTeam_PlayerAction_values[0]);
                }
                case 4: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofString.invoke(null, team, packet.getPlayers().toArray(new String[0])[0], this.nms.PacketPlayOutScoreboardTeam_PlayerAction_values[1]);
                }
            }
            throw new IllegalArgumentException("Invalid action: " + packet.getAction());
        }
        return this.nms.newPacketPlayOutScoreboardTeam.newInstance(team, packet.getAction());
    }

    public Object build(PacketPlayOutEntityDestroy packet) throws ReflectiveOperationException {
        try {
            return this.nms.newPacketPlayOutEntityDestroy.newInstance(new Object[]{packet.getEntities()});
        }
        catch (IllegalArgumentException e) {
            return this.nms.newPacketPlayOutEntityDestroy.newInstance(packet.getEntities()[0]);
        }
    }

    public Object build(PacketPlayOutEntityMetadata packet) throws ReflectiveOperationException {
        return this.nms.newPacketPlayOutEntityMetadata.newInstance(packet.getEntityId(), packet.getDataWatcher().toNMS(), true);
    }

    public Object build(PacketPlayOutSpawnEntityLiving packet) throws ReflectiveOperationException {
        Object nmsPacket = this.nms.getMinorVersion() >= 17 ? this.nms.newPacketPlayOutSpawnEntityLiving.newInstance(this.nms.dummyEntity) : this.nms.newPacketPlayOutSpawnEntityLiving.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_ENTITYID, packet.getEntityId());
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_YAW, (byte)(packet.getLocation().getYaw() * 256.0f / 360.0f));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_PITCH, (byte)(packet.getLocation().getPitch() * 256.0f / 360.0f));
        if (this.nms.getMinorVersion() <= 14) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_DATAWATCHER, packet.getDataWatcher().toNMS());
        }
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_UUID, packet.getUniqueId());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_X, packet.getLocation().getX());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Y, packet.getLocation().getY());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Z, packet.getLocation().getZ());
        } else {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_X, this.floor(packet.getLocation().getX() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Y, this.floor(packet.getLocation().getY() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Z, this.floor(packet.getLocation().getZ() * 32.0));
        }
        int id = this.entityIds.get(packet.getEntityType());
        if (this.nms.getMinorVersion() >= 19) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_ENTITYTYPE, this.nms.Registry_a.invoke(this.nms.IRegistry_X, id));
        } else {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_ENTITYTYPE, id);
        }
        return nmsPacket;
    }

    public Object build(PacketPlayOutEntityTeleport packet) throws ReflectiveOperationException {
        Object nmsPacket = this.nms.getMinorVersion() >= 17 ? this.nms.newPacketPlayOutEntityTeleport.newInstance(this.nms.dummyEntity) : this.nms.newPacketPlayOutEntityTeleport.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_ENTITYID, packet.getEntityId());
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_X, packet.getLocation().getX());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Y, packet.getLocation().getY());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Z, packet.getLocation().getZ());
        } else {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_X, this.floor(packet.getLocation().getX() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Y, this.floor(packet.getLocation().getY() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Z, this.floor(packet.getLocation().getZ() * 32.0));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_YAW, (byte)(packet.getLocation().getYaw() / 360.0f * 256.0f));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_PITCH, (byte)(packet.getLocation().getPitch() / 360.0f * 256.0f));
        return nmsPacket;
    }

    private void createTeamModern(PacketPlayOutScoreboardTeam packet, ProtocolVersion clientVersion, Object team, String prefix, String suffix) throws ReflectiveOperationException {
        if (prefix != null) {
            this.nms.ScoreboardTeam_setPrefix.invoke(team, this.toNMSComponent(IChatBaseComponent.optimizedComponent(prefix), clientVersion));
        }
        if (suffix != null) {
            this.nms.ScoreboardTeam_setSuffix.invoke(team, this.toNMSComponent(IChatBaseComponent.optimizedComponent(suffix), clientVersion));
        }
        EnumChatFormat format = packet.getColor() != null ? packet.getColor() : EnumChatFormat.lastColorsOf(prefix);
        this.nms.ScoreboardTeam_setColor.invoke(team, this.nms.EnumChatFormat_values[format.ordinal()]);
        this.nms.ScoreboardTeam_setNameTagVisibility.invoke(team, String.valueOf(packet.getNameTagVisibility()).equals("always") ? this.nms.EnumNameTagVisibility_values[0] : this.nms.EnumNameTagVisibility_values[1]);
        this.nms.ScoreboardTeam_setCollisionRule.invoke(team, String.valueOf(packet.getCollisionRule()).equals("always") ? this.nms.EnumTeamPush_values[0] : this.nms.EnumTeamPush_values[1]);
    }

    private void createTeamLegacy(PacketPlayOutScoreboardTeam packet, Object team, String prefix, String suffix) throws ReflectiveOperationException {
        if (prefix != null) {
            this.nms.ScoreboardTeam_setPrefix.invoke(team, prefix);
        }
        if (suffix != null) {
            this.nms.ScoreboardTeam_setSuffix.invoke(team, suffix);
        }
        if (this.nms.getMinorVersion() >= 8) {
            this.nms.ScoreboardTeam_setNameTagVisibility.invoke(team, String.valueOf(packet.getNameTagVisibility()).equals("always") ? this.nms.EnumNameTagVisibility_values[0] : this.nms.EnumNameTagVisibility_values[1]);
        }
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.ScoreboardTeam_setCollisionRule.invoke(team, String.valueOf(packet.getCollisionRule()).equals("always") ? this.nms.EnumTeamPush_values[0] : this.nms.EnumTeamPush_values[1]);
        }
    }

    @Override
    public PacketPlayOutPlayerInfo readPlayerInfo(Object nmsPacket, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.valueOf(this.nms.PacketPlayOutPlayerInfo_ACTION.get(nmsPacket).toString());
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> listData = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (Object nmsData : (List)this.nms.PacketPlayOutPlayerInfo_PLAYERS.get(nmsPacket)) {
            Object nmsGameMode = this.nms.PlayerInfoData_getGamemode.invoke(nmsData, new Object[0]);
            PacketPlayOutPlayerInfo.EnumGamemode gameMode = nmsGameMode == null ? null : PacketPlayOutPlayerInfo.EnumGamemode.valueOf(nmsGameMode.toString());
            GameProfile profile = (GameProfile)this.nms.PlayerInfoData_getProfile.invoke(nmsData, new Object[0]);
            Object nmsComponent = this.nms.PlayerInfoData_getDisplayName.invoke(nmsData, new Object[0]);
            WrappedChatComponent listName = nmsComponent == null ? null : new WrappedChatComponent(nmsComponent);
            Skin skin = null;
            if (!profile.getProperties().get((Object)"textures").isEmpty()) {
                Property pr = (Property)profile.getProperties().get((Object)"textures").iterator().next();
                skin = new Skin(pr.getValue(), pr.getSignature());
            }
            Object profilePublicKey = this.nms.getMinorVersion() >= 19 ? this.nms.PlayerInfoData_getProfilePublicKeyRecord.invoke(nmsData, new Object[0]) : null;
            listData.add(new PacketPlayOutPlayerInfo.PlayerInfoData(profile.getName(), profile.getId(), skin, (Integer)this.nms.PlayerInfoData_getLatency.invoke(nmsData, new Object[0]), gameMode, listName, profilePublicKey));
        }
        return new PacketPlayOutPlayerInfo(action, listData);
    }

    @Override
    public PacketPlayOutScoreboardObjective readObjective(Object nmsPacket) throws ReflectiveOperationException {
        return new PacketPlayOutScoreboardObjective(this.nms.PacketPlayOutScoreboardObjective_METHOD.getInt(nmsPacket), (String)this.nms.PacketPlayOutScoreboardObjective_OBJECTIVENAME.get(nmsPacket), null, PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER);
    }

    @Override
    public PacketPlayOutScoreboardDisplayObjective readDisplayObjective(Object nmsPacket) throws ReflectiveOperationException {
        return new PacketPlayOutScoreboardDisplayObjective(this.nms.PacketPlayOutScoreboardDisplayObjective_POSITION.getInt(nmsPacket), (String)this.nms.PacketPlayOutScoreboardDisplayObjective_OBJECTIVENAME.get(nmsPacket));
    }

    private Object buildBossPacketEntity(PacketPlayOutBoss packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (packet.getAction() == PacketPlayOutBoss.Action.UPDATE_STYLE) {
            return null;
        }
        int entityId = packet.getId().hashCode();
        if (packet.getAction() == PacketPlayOutBoss.Action.REMOVE) {
            return this.build(new PacketPlayOutEntityDestroy(entityId));
        }
        DataWatcher w = new DataWatcher();
        if (packet.getAction() == PacketPlayOutBoss.Action.UPDATE_PCT || packet.getAction() == PacketPlayOutBoss.Action.ADD) {
            float health = 300.0f * packet.getPct();
            if (health == 0.0f) {
                health = 1.0f;
            }
            w.helper().setHealth(health);
        }
        if (packet.getAction() == PacketPlayOutBoss.Action.UPDATE_NAME || packet.getAction() == PacketPlayOutBoss.Action.ADD) {
            w.helper().setCustomName(packet.getName(), clientVersion);
        }
        if (packet.getAction() == PacketPlayOutBoss.Action.ADD) {
            w.helper().setEntityFlags((byte)32);
            w.helper().setWitherInvulnerableTime(880);
            return this.build(new PacketPlayOutSpawnEntityLiving(entityId, new UUID(0L, 0L), EntityType.WITHER, new Location(null, 0.0, 0.0, 0.0), w));
        }
        return this.build(new PacketPlayOutEntityMetadata(entityId, w));
    }

    private int floor(double paramDouble) {
        int i = (int)paramDouble;
        return paramDouble < (double)i ? i - 1 : i;
    }

    public Object toNMSComponent(IChatBaseComponent component, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        Map<IChatBaseComponent, Object> cache;
        if (component == null) {
            return null;
        }
        if (component instanceof WrappedChatComponent) {
            return ((WrappedChatComponent)component).get();
        }
        Map<IChatBaseComponent, Object> map = cache = clientVersion.getMinorVersion() >= 16 ? this.componentCacheModern : this.componentCacheLegacy;
        if (cache.containsKey(component)) {
            return cache.get(component);
        }
        if (cache.size() > 10000) {
            cache.clear();
        }
        Object chat = this.nms.ChatSerializer_DESERIALIZE.invoke(null, component.toString(clientVersion));
        cache.put(component, chat);
        return chat;
    }

    private Object newScoreboardObjective(String objectiveName) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newScoreboardObjective.newInstance(null, objectiveName, null, this.toNMSComponent(new IChatBaseComponent(""), TabAPI.getInstance().getServerVersion()), null);
        }
        return this.nms.newScoreboardObjective.newInstance(null, objectiveName, this.nms.IScoreboardCriteria_self.get(null));
    }
}

