/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PipelineInjector;
import org.jetbrains.annotations.NotNull;

public class BukkitPipelineInjector
extends PipelineInjector {
    private final NMSStorage nms = NMSStorage.getInstance();

    public BukkitPipelineInjector() {
        super("packet_handler");
    }

    @Override
    public Function<TabPlayer, ChannelDuplexHandler> getChannelFunction() {
        return x$0 -> new BukkitChannelDuplexHandler((TabPlayer)x$0);
    }

    public class BukkitChannelDuplexHandler
    extends ChannelDuplexHandler {
        private final TabPlayer player;

        public BukkitChannelDuplexHandler(TabPlayer player) {
            this.player = player;
        }

        public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object packet) {
            try {
                if (TAB.getInstance().getFeatureManager().onPacketReceive(this.player, packet)) {
                    return;
                }
                super.channelRead(context, packet);
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("An error occurred when reading packets", e);
            }
        }

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) {
            try {
                if (((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutPlayerInfo.isInstance(packet)) {
                    super.write(context, TAB.getInstance().getFeatureManager().onPacketPlayOutPlayerInfo(this.player, packet), channelPromise);
                    return;
                }
                if (BukkitPipelineInjector.this.antiOverrideTeams && ((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam != null && ((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam.isInstance(packet)) {
                    long time = System.nanoTime();
                    this.modifyPlayers(packet);
                    TAB.getInstance().getCPUManager().addTime("NameTags", "Anti override", System.nanoTime() - time);
                    super.write(context, packet, channelPromise);
                    return;
                }
                if (((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardDisplayObjective.isInstance(packet)) {
                    TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, packet);
                }
                if (((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardObjective.isInstance(packet)) {
                    TAB.getInstance().getFeatureManager().onObjective(this.player, packet);
                }
                TAB.getInstance().getFeatureManager().onPacketSend(this.player, packet);
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("An error occurred when reading packets", e);
            }
            try {
                super.write(context, packet, channelPromise);
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("Failed to forward packet " + packet.getClass().getSimpleName() + " to " + this.player.getName(), e);
            }
        }

        private void modifyPlayers(Object packetPlayOutScoreboardTeam) throws ReflectiveOperationException {
            int action = ((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam_ACTION.getInt(packetPlayOutScoreboardTeam);
            if (action == 1 || action == 2 || action == 4) {
                return;
            }
            Collection players = (Collection)((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam_PLAYERS.get(packetPlayOutScoreboardTeam);
            String teamName = (String)((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam_NAME.get(packetPlayOutScoreboardTeam);
            if (players == null) {
                return;
            }
            ArrayList<String> newList = new ArrayList<String>();
            for (String entry : players) {
                TabPlayer p = this.getPlayer(entry);
                if (p == null) {
                    newList.add(entry);
                    continue;
                }
                if (!(((TabFeature)((Object)TAB.getInstance().getTeamManager())).isDisabledPlayer(p) || TAB.getInstance().getTeamManager().hasTeamHandlingPaused(p) || teamName.equals(p.getTeamName()))) {
                    BukkitPipelineInjector.this.logTeamOverride(teamName, p.getName(), p.getTeamName());
                    continue;
                }
                newList.add(entry);
            }
            BukkitPipelineInjector.this.nms.setField(packetPlayOutScoreboardTeam, ((BukkitPipelineInjector)BukkitPipelineInjector.this).nms.PacketPlayOutScoreboardTeam_PLAYERS, newList);
        }

        private TabPlayer getPlayer(String name) {
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!p.getNickname().equals(name)) continue;
                return p;
            }
            return null;
        }
    }
}

