/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.earth2me.essentials.Essentials;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Locale;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;
import net.ess3.api.events.NickChangeEvent;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlaceholderRegistry
extends UniversalPlaceholderRegistry {
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
    private final JavaPlugin plugin;
    private Chat chat;
    private final Plugin essentials = Bukkit.getPluginManager().getPlugin("Essentials");
    private Object server;
    private Field recentTps;
    private Method paperTps;
    private Method paperMspt;
    private Method purpurIsAfk;

    public BukkitPlaceholderRegistry(JavaPlugin plugin) {
        RegisteredServiceProvider rspChat;
        this.plugin = plugin;
        this.numberFormat.setMaximumFractionDigits(2);
        if (Bukkit.getPluginManager().isPluginEnabled("Vault") && (rspChat = Bukkit.getServicesManager().getRegistration(Chat.class)) != null) {
            this.chat = (Chat)rspChat.getProvider();
        }
        try {
            this.server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            this.recentTps = this.server.getClass().getField("recentTps");
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        try {
            this.paperTps = Bukkit.class.getMethod("getTPS", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.paperMspt = Bukkit.class.getMethod("getAverageTickTime", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.purpurIsAfk = Player.class.getMethod("isAfk", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void registerPlaceholders(PlaceholderManager manager) {
        super.registerPlaceholders(manager);
        manager.registerPlayerPlaceholder("%displayname%", 500, p -> ((Player)p.getPlayer()).getDisplayName());
        if (this.paperTps != null) {
            manager.registerServerPlaceholder("%tps%", 1000, () -> this.formatTPS(Bukkit.getTPS()[0]));
        } else if (this.recentTps != null) {
            manager.registerServerPlaceholder("%tps%", 1000, () -> {
                try {
                    return this.formatTPS(((double[])this.recentTps.get(this.server))[0]);
                }
                catch (IllegalAccessException e) {
                    return -1;
                }
            });
        } else {
            manager.registerServerPlaceholder("%tps%", -1, () -> -1);
        }
        if (this.paperMspt != null) {
            manager.registerServerPlaceholder("%mspt%", 1000, () -> this.numberFormat.format(Bukkit.getAverageTickTime()));
        }
        manager.registerPlayerPlaceholder("%afk%", 500, p -> {
            if (this.essentials != null && ((Essentials)this.essentials).getUser(p.getUniqueId()).isAfk()) {
                return true;
            }
            return this.purpurIsAfk != null && ((Player)p.getPlayer()).isAfk();
        });
        if (this.essentials != null) {
            final PlayerPlaceholder nick = manager.registerPlayerPlaceholder("%essentialsnick%", -1, p -> {
                String nickname = ((Essentials)this.essentials).getUser(p.getUniqueId()).getNickname();
                return nickname == null ? p.getName() : nickname;
            });
            Listener nickListener = new Listener(){

                @EventHandler
                public void onNickChange(NickChangeEvent e) {
                    String name = e.getValue() == null ? e.getAffected().getName() : e.getValue();
                    TabPlayer player = TAB.getInstance().getPlayer(e.getAffected().getUUID());
                    if (player == null) {
                        return;
                    }
                    nick.updateValue(player, name);
                }
            };
            nick.enableTriggerMode(() -> Bukkit.getPluginManager().registerEvents(nickListener, (Plugin)this.plugin), () -> HandlerList.unregisterAll((Listener)nickListener));
        } else {
            manager.registerPlayerPlaceholder("%essentialsnick%", -1, TabPlayer::getName);
        }
        if (this.chat != null) {
            manager.registerPlayerPlaceholder("%vault-prefix%", 1000, p -> this.chat.getPlayerPrefix((Player)p.getPlayer()));
            manager.registerPlayerPlaceholder("%vault-suffix%", 1000, p -> this.chat.getPlayerSuffix((Player)p.getPlayer()));
        } else {
            manager.registerServerPlaceholder("%vault-prefix%", -1, () -> "");
            manager.registerServerPlaceholder("%vault-suffix%", -1, () -> "");
        }
        manager.registerPlayerPlaceholder("%health%", 100, p -> (int)Math.ceil(((Player)p.getPlayer()).getHealth()));
    }

    private String formatTPS(double tps) {
        return this.numberFormat.format(Math.min(20.0, tps));
    }
}

