/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.earth2me.essentials.Essentials;
import com.viaversion.viaversion.api.Via;
import java.util.Collection;
import me.clip.placeholderapi.PlaceholderAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.platforms.bukkit.BukkitPacketBuilder;
import me.neznamy.tab.platforms.bukkit.BukkitPipelineInjector;
import me.neznamy.tab.platforms.bukkit.BukkitPlaceholderRegistry;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.event.TabLoadEvent;
import me.neznamy.tab.platforms.bukkit.event.TabPlayerLoadEvent;
import me.neznamy.tab.platforms.bukkit.features.BukkitTabExpansion;
import me.neznamy.tab.platforms.bukkit.features.PerWorldPlayerList;
import me.neznamy.tab.platforms.bukkit.features.PetFix;
import me.neznamy.tab.platforms.bukkit.features.WitherBossBar;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitNameTagX;
import me.neznamy.tab.platforms.bukkit.permission.Vault;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.None;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlatform
extends Platform {
    private final JavaPlugin plugin;
    private final boolean placeholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    private boolean libsDisguises = Bukkit.getPluginManager().isPluginEnabled("LibsDisguises");
    private final Plugin essentials = Bukkit.getPluginManager().getPlugin("Essentials");
    private Plugin viaVersion;
    private final boolean protocolSupport = Bukkit.getPluginManager().isPluginEnabled("ProtocolSupport");

    public BukkitPlatform(JavaPlugin plugin) {
        super(new BukkitPacketBuilder());
        this.plugin = plugin;
    }

    @Override
    public PermissionPlugin detectPermissionPlugin() {
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            return new LuckPerms(this.getPluginVersion("LuckPerms"));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (provider == null) {
                return new None();
            }
            return new Vault((Permission)provider.getProvider(), this.getPluginVersion("Vault"));
        }
        return new None();
    }

    @Override
    public void loadFeatures() {
        TAB tab;
        if (Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
            try {
                Class.forName("com.viaversion.viaversion.api.Via");
                this.viaVersion = Bukkit.getPluginManager().getPlugin("ViaVersion");
            }
            catch (ClassNotFoundException e) {
                TAB.getInstance().sendConsoleMessage("&cAn outdated version of ViaVersion (" + this.getPluginVersion("ViaVersion") + ") was detected.", true);
                TAB.getInstance().sendConsoleMessage("&cTAB only supports ViaVersion 4.0.0 and above. Disabling ViaVersion hook.", true);
                TAB.getInstance().sendConsoleMessage("&cThis might cause problems, such as limitations still being present for latest MC clients as well as RGB not working.", true);
            }
        }
        if ((tab = TAB.getInstance()).getConfiguration().isPipelineInjection()) {
            tab.getFeatureManager().registerFeature("injection", new BukkitPipelineInjector());
        }
        new BukkitPlaceholderRegistry(this.plugin).registerPlaceholders(tab.getPlaceholderManager());
        if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.enabled", true)) {
            if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.enabled", false) && tab.getServerVersion().getMinorVersion() >= 8) {
                tab.getFeatureManager().registerFeature("NameTagX", new BukkitNameTagX(this.plugin));
            } else {
                tab.getFeatureManager().registerFeature("NameTag16", new NameTag());
            }
        }
        tab.loadUniversalFeatures();
        if (tab.getConfiguration().getConfig().getBoolean("bossbar.enabled", false)) {
            if (tab.getServerVersion().getMinorVersion() < 9) {
                tab.getFeatureManager().registerFeature("BossBar", new WitherBossBar(this.plugin));
            } else {
                tab.getFeatureManager().registerFeature("BossBar", new BossBarManagerImpl());
            }
        }
        if (tab.getServerVersion().getMinorVersion() >= 9 && tab.getConfiguration().getConfig().getBoolean("fix-pet-names.enabled", false)) {
            tab.getFeatureManager().registerFeature("PetFix", new PetFix());
        }
        if (tab.getConfiguration().getConfig().getBoolean("per-world-playerlist.enabled", false)) {
            tab.getFeatureManager().registerFeature("PerWorldPlayerList", new PerWorldPlayerList(this.plugin));
        }
        if (this.placeholderAPI && tab.getConfiguration().getConfig().getBoolean("placeholders.register-tab-expansion", true)) {
            BukkitTabExpansion expansion = new BukkitTabExpansion();
            expansion.register();
            TAB.getInstance().getPlaceholderManager().setTabExpansion(expansion);
        }
        for (Player p : this.getOnlinePlayers()) {
            tab.addPlayer(new BukkitTabPlayer(p, this.getProtocolVersion(p)));
        }
    }

    @Override
    public String getPluginVersion(String plugin) {
        Plugin pl = Bukkit.getPluginManager().getPlugin(plugin);
        return pl == null ? null : pl.getDescription().getVersion();
    }

    private Player[] getOnlinePlayers() {
        try {
            Object players = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
            if (players instanceof Player[]) {
                return (Player[])players;
            }
            return ((Collection)players).toArray(new Player[0]);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get online players", e);
            return new Player[0];
        }
    }

    @Override
    public void registerUnknownPlaceholder(String identifier) {
        PlaceholderManagerImpl pl = TAB.getInstance().getPlaceholderManager();
        if (identifier.startsWith("%rel_")) {
            TAB.getInstance().getPlaceholderManager().registerRelationalPlaceholder(identifier, pl.getRelationalRefresh(identifier), (viewer, target) -> this.placeholderAPI ? PlaceholderAPI.setRelationalPlaceholders((Player)((Player)viewer.getPlayer()), (Player)((Player)target.getPlayer()), (String)identifier) : identifier);
        } else {
            if (identifier.startsWith("%sync:")) {
                int refresh = pl.getServerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh()));
                final String syncedPlaceholder = "%" + identifier.substring(6, identifier.length() - 1) + "%";
                pl.registerPlaceholder(new PlayerPlaceholderImpl(identifier, refresh, null){

                    @Override
                    public Object request(TabPlayer p) {
                        Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.this.plugin, () -> {
                            long time = System.nanoTime();
                            this.updateValue(p, BukkitPlatform.this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)syncedPlaceholder) : this.identifier);
                            TAB.getInstance().getCPUManager().addPlaceholderTime(this.getIdentifier(), System.nanoTime() - time);
                        });
                        return null;
                    }
                });
                return;
            }
            if (pl.getServerPlaceholderRefreshIntervals().containsKey(identifier)) {
                TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(identifier, pl.getServerPlaceholderRefreshIntervals().get(identifier), () -> this.placeholderAPI ? PlaceholderAPI.setPlaceholders(null, (String)identifier) : identifier);
            } else {
                int refresh = pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh());
                TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(identifier, refresh, p -> this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)identifier) : identifier);
            }
        }
    }

    @Override
    public void callLoadEvent() {
        Bukkit.getPluginManager().callEvent((Event)new TabLoadEvent());
    }

    @Override
    public void callLoadEvent(TabPlayer player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TabPlayerLoadEvent(player)));
    }

    public boolean isLibsDisguisesEnabled() {
        return this.libsDisguises;
    }

    public void setLibsDisguisesEnabled(boolean enabled) {
        this.libsDisguises = enabled;
    }

    public Essentials getEssentials() {
        return (Essentials)this.essentials;
    }

    @Override
    public String getConfigName() {
        return "bukkitconfig.yml";
    }

    public int getProtocolVersion(Player player) {
        int version;
        if (this.protocolSupport && (version = this.getProtocolVersionPS(player)) != -1 && version < TAB.getInstance().getServerVersion().getNetworkId()) {
            return version;
        }
        if (this.viaVersion != null) {
            return this.getProtocolVersionVia(player, 0);
        }
        return TAB.getInstance().getServerVersion().getNetworkId();
    }

    private int getProtocolVersionPS(Player player) {
        try {
            Object protocolVersion = Class.forName("protocolsupport.api.ProtocolSupportAPI").getMethod("getProtocolVersion", Player.class).invoke(null, player);
            int version = (Integer)protocolVersion.getClass().getMethod("getId", new Class[0]).invoke(protocolVersion, new Object[0]);
            TAB.getInstance().debug("ProtocolSupport returned protocol version " + version + " for " + player.getName() + " (online=" + player.isOnline() + ")");
            return version;
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError(String.format("Failed to get protocol version of %s using ProtocolSupport", player.getName()), e);
            return TAB.getInstance().getServerVersion().getNetworkId();
        }
    }

    private int getProtocolVersionVia(Player player, int retryLevel) {
        try {
            if (retryLevel == 10) {
                TAB.getInstance().debug("Failed to get protocol version of " + player.getName() + " after 10 retries");
                return TAB.getInstance().getServerVersion().getNetworkId();
            }
            int version = Via.getAPI().getPlayerVersion(player.getUniqueId());
            if (version == -1) {
                if (!player.isOnline()) {
                    return TAB.getInstance().getServerVersion().getNetworkId();
                }
                Thread.sleep(5L);
                return this.getProtocolVersionVia(player, retryLevel + 1);
            }
            TAB.getInstance().debug("ViaVersion returned protocol version " + version + " for " + player.getName() + " (online=" + player.isOnline() + ")");
            return version;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
        catch (Exception | LinkageError e) {
            TAB.getInstance().getErrorManager().printError(String.format("Failed to get protocol version of %s using ViaVersion v%s", player.getName(), this.viaVersion.getDescription().getVersion()), e);
            return TAB.getInstance().getServerVersion().getNetworkId();
        }
    }

    @Override
    public void sendConsoleMessage(String message, boolean translateColors) {
        Bukkit.getConsoleSender().sendMessage("[TAB] " + (translateColors ? EnumChatFormat.color(message) : message));
    }
}

