/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcherItem;

public class PetFix
extends TabFeature {
    private final NMSStorage nms = NMSStorage.getInstance();
    private final int petOwnerPosition = this.getPetOwnerPosition();
    private final WeakHashMap<TabPlayer, Long> lastInteractFix = new WeakHashMap();
    private static final int INTERACT_COOLDOWN = 160;

    public PetFix() {
        super("Pet name fix", null);
        TabAPI.getInstance().debug("Loaded PetFix feature");
    }

    private int getPetOwnerPosition() {
        if (this.nms.getMinorVersion() >= 17) {
            return 18;
        }
        if (this.nms.getMinorVersion() >= 15) {
            return 17;
        }
        if (this.nms.getMinorVersion() >= 14) {
            return 16;
        }
        if (this.nms.getMinorVersion() >= 10) {
            return 14;
        }
        return 13;
    }

    @Override
    public boolean onPacketReceive(TabPlayer sender, Object packet) throws ReflectiveOperationException {
        if (this.nms.PacketPlayInUseEntity.isInstance(packet) && this.isInteract(this.nms.PacketPlayInUseEntity_ACTION.get(packet))) {
            if (System.currentTimeMillis() - this.lastInteractFix.getOrDefault(sender, 0L) < 160L) {
                return true;
            }
            this.lastInteractFix.put(sender, System.currentTimeMillis());
        }
        return false;
    }

    private boolean isInteract(Object action) {
        if (this.nms.getMinorVersion() >= 17) {
            return this.nms.PacketPlayInUseEntity$d.isInstance(action);
        }
        return action.toString().equals("INTERACT");
    }

    @Override
    public void onPacketSend(TabPlayer receiver, Object packet) throws ReflectiveOperationException {
        DataWatcher watcher;
        DataWatcherItem petOwner;
        if (this.nms.PacketPlayOutEntityMetadata.isInstance(packet)) {
            Object removedEntry = null;
            List items = (List)this.nms.PacketPlayOutEntityMetadata_LIST.get(packet);
            if (items == null) {
                return;
            }
            try {
                for (Object item : items) {
                    Object value;
                    if (item == null || this.nms.DataWatcherObject_SLOT.getInt(this.nms.DataWatcherItem_TYPE.get(item)) != this.petOwnerPosition || !((value = this.nms.DataWatcherItem_VALUE.get(item)) instanceof Optional) && !(value instanceof com.google.common.base.Optional)) continue;
                    removedEntry = item;
                }
            }
            catch (ConcurrentModificationException e) {
                this.onPacketSend(receiver, packet);
            }
            if (removedEntry != null) {
                items.remove(removedEntry);
            }
        } else if (this.nms.PacketPlayOutSpawnEntityLiving.isInstance(packet) && this.nms.PacketPlayOutSpawnEntityLiving_DATAWATCHER != null && (petOwner = (watcher = DataWatcher.fromNMS(this.nms.PacketPlayOutSpawnEntityLiving_DATAWATCHER.get(packet))).getItem(this.petOwnerPosition)) != null && (petOwner.getValue() instanceof Optional || petOwner.getValue() instanceof com.google.common.base.Optional)) {
            watcher.removeValue(this.petOwnerPosition);
            this.nms.setField(packet, this.nms.PacketPlayOutSpawnEntityLiving_DATAWATCHER, watcher.toNMS());
        }
    }
}

