/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.ArmorStandManager;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitArmorStand;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;

public class BukkitArmorStandManager
implements ArmorStandManager {
    private final Map<String, ArmorStand> armorStands = new LinkedHashMap<String, ArmorStand>();
    private final List<TabPlayer> nearbyPlayers = new ArrayList<TabPlayer>();
    private ArmorStand[] armorStandArray = new ArmorStand[0];
    private TabPlayer[] nearbyPlayerArray = new TabPlayer[0];

    public BukkitArmorStandManager(NameTagX nameTagX, TabPlayer owner) {
        owner.setProperty(nameTagX, "nametag", owner.getProperty("tagprefix").getCurrentRawValue() + owner.getProperty("customtagname").getCurrentRawValue() + owner.getProperty("tagsuffix").getCurrentRawValue());
        double height = 0.0;
        for (String string : nameTagX.getDynamicLines()) {
            this.addArmorStand(string, new BukkitArmorStand(this, owner, string, height, false));
            height += 0.26;
        }
        for (Map.Entry entry : nameTagX.getStaticLines().entrySet()) {
            this.addArmorStand((String)entry.getKey(), new BukkitArmorStand(this, owner, (String)entry.getKey(), Double.parseDouble(entry.getValue().toString()), true));
        }
        this.fixArmorStandHeights();
    }

    public void teleport(TabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport(viewer);
        }
    }

    public void teleport() {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport();
        }
    }

    public TabPlayer[] getNearbyPlayers() {
        return this.nearbyPlayerArray;
    }

    public boolean isNearby(TabPlayer viewer) {
        return this.nearbyPlayers.contains(viewer);
    }

    public boolean hasArmorStandWithID(int entityId) {
        for (ArmorStand a : this.armorStandArray) {
            if (a.getEntityId() != entityId) continue;
            return true;
        }
        return false;
    }

    public void sneak(boolean sneaking) {
        for (ArmorStand a : this.armorStandArray) {
            a.sneak(sneaking);
        }
    }

    public void respawn() {
        for (ArmorStand a : this.armorStandArray) {
            for (TabPlayer viewer : this.nearbyPlayerArray) {
                a.respawn(viewer);
            }
        }
    }

    public void spawn(TabPlayer viewer) {
        this.nearbyPlayers.add(viewer);
        this.nearbyPlayerArray = this.nearbyPlayers.toArray(new TabPlayer[0]);
        if (viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        for (ArmorStand a : this.armorStandArray) {
            a.spawn(viewer);
        }
    }

    public void fixArmorStandHeights() {
        double currentY = -0.26;
        for (ArmorStand as : this.armorStandArray) {
            if (as.hasStaticOffset() || as.getProperty().get().length() == 0) continue;
            as.setOffset(currentY += 0.26);
        }
    }

    public void addArmorStand(String name, ArmorStand as) {
        this.armorStands.put(name, as);
        this.armorStandArray = this.armorStands.values().toArray(new ArmorStand[0]);
        for (TabPlayer p : this.nearbyPlayerArray) {
            as.spawn(p);
        }
    }

    public void unregisterPlayer(TabPlayer viewer) {
        if (this.nearbyPlayers.remove(viewer)) {
            this.nearbyPlayerArray = this.nearbyPlayers.toArray(new TabPlayer[0]);
        }
    }

    public void updateVisibility(boolean force) {
        for (ArmorStand a : this.armorStandArray) {
            a.updateVisibility(force);
        }
    }

    public void destroy(TabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            a.destroy(viewer);
        }
        this.unregisterPlayer(viewer);
    }

    @Override
    public void destroy() {
        for (ArmorStand a : this.armorStandArray) {
            a.destroy();
        }
        this.nearbyPlayers.clear();
        this.nearbyPlayerArray = new TabPlayer[0];
    }

    @Override
    public void refresh(boolean force) {
        boolean fix = false;
        for (ArmorStand as : this.armorStandArray) {
            if (!as.getProperty().update() && !force) continue;
            as.refresh();
            fix = true;
        }
        if (fix) {
            this.fixArmorStandHeights();
        }
    }
}

