/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitArmorStandManager;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitNameTagX;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketListener
extends TabFeature {
    private final BukkitNameTagX nameTagX;
    private final Map<Integer, TabPlayer> entityIdMap = new ConcurrentHashMap<Integer, TabPlayer>();
    private final NMSStorage nms = NMSStorage.getInstance();

    public PacketListener(BukkitNameTagX nameTagX) {
        super(nameTagX.getFeatureName(), null);
        this.nameTagX = nameTagX;
    }

    @Override
    public void load() {
        for (TabPlayer all : TabAPI.getInstance().getOnlinePlayers()) {
            this.entityIdMap.put(((Player)all.getPlayer()).getEntityId(), all);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.entityIdMap.put(((Player)connectedPlayer.getPlayer()).getEntityId(), connectedPlayer);
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        this.entityIdMap.remove(((Player)disconnectedPlayer.getPlayer()).getEntityId());
    }

    @Override
    public boolean onPacketReceive(TabPlayer sender, Object packet) throws ReflectiveOperationException {
        if (sender.getVersion().getMinorVersion() == 8 && this.nms.PacketPlayInUseEntity.isInstance(packet)) {
            int entityId = this.nms.PacketPlayInUseEntity_ENTITY.getInt(packet);
            TabPlayer attacked = null;
            for (TabPlayer all : TabAPI.getInstance().getOnlinePlayers()) {
                if (!all.isLoaded() || !this.nameTagX.getArmorStandManager(all).hasArmorStandWithID(entityId)) continue;
                attacked = all;
                break;
            }
            if (attacked != null && attacked != sender) {
                this.nms.setField(packet, this.nms.PacketPlayInUseEntity_ENTITY, ((Player)attacked.getPlayer()).getEntityId());
            }
        }
        return false;
    }

    @Override
    public void onPacketSend(TabPlayer receiver, Object packet) throws ReflectiveOperationException {
        if (receiver.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (!receiver.isLoaded() || this.nameTagX.isDisabledPlayer(receiver) || this.nameTagX.getDisabledUnlimitedPlayers().contains(receiver)) {
            return;
        }
        if (this.nms.PacketPlayOutEntity.isInstance(packet) && !this.nms.PacketPlayOutEntityLook.isInstance(packet)) {
            this.onEntityMove(receiver, this.nms.PacketPlayOutEntity_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutEntityTeleport.isInstance(packet)) {
            this.onEntityMove(receiver, this.nms.PacketPlayOutEntityTeleport_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutNamedEntitySpawn.isInstance(packet)) {
            this.onEntitySpawn(receiver, this.nms.PacketPlayOutNamedEntitySpawn_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutEntityDestroy.isInstance(packet)) {
            if (this.nms.getMinorVersion() >= 17) {
                Object entities = this.nms.PacketPlayOutEntityDestroy_ENTITIES.get(packet);
                if (entities instanceof List) {
                    this.onEntityDestroy(receiver, (List)entities);
                } else {
                    this.onEntityDestroy(receiver, (int)((Integer)entities));
                }
            } else {
                this.onEntityDestroy(receiver, (int[])this.nms.PacketPlayOutEntityDestroy_ENTITIES.get(packet));
            }
        }
    }

    private void onEntityMove(TabPlayer receiver, int entityId) {
        TabPlayer pl = this.entityIdMap.get(entityId);
        if (pl != null) {
            if (this.nameTagX.isPlayerDisabled(pl) || !pl.isLoaded()) {
                return;
            }
            TabAPI.getInstance().getThreadManager().runMeasuredTask(this.nameTagX, "PacketPlayOutEntity", () -> this.nameTagX.getArmorStandManager(pl).teleport(receiver));
        } else {
            List<Entity> vehicleList = this.nameTagX.getVehicleManager().getVehicles().get(entityId);
            if (vehicleList != null) {
                for (Entity entity : vehicleList) {
                    TabPlayer passenger = this.entityIdMap.get(entity.getEntityId());
                    if (passenger == null || this.nameTagX.getArmorStandManager(passenger) == null) continue;
                    TabAPI.getInstance().getThreadManager().runMeasuredTask(this.nameTagX, "PacketPlayOutEntity (passenger)", () -> this.nameTagX.getArmorStandManager(passenger).teleport(receiver));
                }
            }
        }
    }

    private void onEntitySpawn(TabPlayer receiver, int entityId) {
        TabPlayer spawnedPlayer = this.entityIdMap.get(entityId);
        if (spawnedPlayer != null && spawnedPlayer.isLoaded() && !this.nameTagX.isPlayerDisabled(spawnedPlayer)) {
            TabAPI.getInstance().getThreadManager().runMeasuredTask(this.nameTagX, "PacketPlayOutNamedEntitySpawn", () -> this.nameTagX.getArmorStandManager(spawnedPlayer).spawn(receiver));
        }
    }

    private void onEntityDestroy(TabPlayer receiver, List<Integer> entities) {
        for (int entity : entities) {
            this.onEntityDestroy(receiver, entity);
        }
    }

    private void onEntityDestroy(TabPlayer receiver, int ... entities) {
        for (int entity : entities) {
            this.onEntityDestroy(receiver, entity);
        }
    }

    private void onEntityDestroy(TabPlayer receiver, int entity) {
        TabPlayer deSpawnedPlayer = this.entityIdMap.get(entity);
        if (deSpawnedPlayer != null && deSpawnedPlayer.isLoaded() && !this.nameTagX.isPlayerDisabled(deSpawnedPlayer)) {
            BukkitArmorStandManager asm = this.nameTagX.getArmorStandManager(deSpawnedPlayer);
            TabAPI.getInstance().getThreadManager().runMeasuredTask(this.nameTagX, "PacketPlayOutEntityDestroy", () -> asm.destroy(receiver));
        }
    }
}

