/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms;

import java.util.Arrays;
import me.neznamy.tab.platforms.bukkit.Main;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;

public class LegacyNMSStorage
extends NMSStorage {
    private Class<?> getLegacyClass(String ... names) throws ClassNotFoundException {
        for (String name : names) {
            try {
                return this.getLegacyClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException("No class found with possible names " + Arrays.toString(names));
    }

    private Class<?> getLegacyClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName("net.minecraft.server." + this.serverPackage + "." + name);
        }
        catch (ClassNotFoundException | NullPointerException e) {
            try {
                Class<?> clazz = Main.class.getClassLoader().loadClass("net.minecraft.server." + this.serverPackage + "." + name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public void loadNamedFieldsAndMethods() throws ReflectiveOperationException {
        this.PING = this.getField(this.EntityPlayer, "ping", "field_71138_i");
        this.ScoreboardScore_setScore = this.getMethod(this.ScoreboardScore, new String[]{"setScore", "func_96647_c"}, Integer.TYPE);
        this.ScoreboardTeam_setAllowFriendlyFire = this.getMethod(this.ScoreboardTeam, new String[]{"setAllowFriendlyFire", "func_96660_a"}, Boolean.TYPE);
        this.ScoreboardTeam_setCanSeeFriendlyInvisibles = this.getMethod(this.ScoreboardTeam, new String[]{"setCanSeeFriendlyInvisibles", "func_98300_b"}, Boolean.TYPE);
        if (this.minorVersion >= 7) {
            this.ChatSerializer_DESERIALIZE = this.getMethod(this.ChatSerializer, new String[]{"a", "func_150699_a"}, String.class);
        }
        if (this.minorVersion >= 8) {
            this.ScoreboardTeam_setNameTagVisibility = this.getMethod(this.ScoreboardTeam, "setNameTagVisibility", this.EnumNameTagVisibility);
        }
        this.DataWatcher_REGISTER = this.minorVersion >= 9 ? this.getMethod(this.DataWatcher, "register", this.DataWatcherObject, Object.class) : this.getMethod(this.DataWatcher, new String[]{"a", "func_75682_a"}, Integer.TYPE, Object.class);
        if (this.minorVersion >= 13) {
            this.ScoreboardTeam_setPrefix = this.getMethod(this.ScoreboardTeam, "setPrefix", this.IChatBaseComponent);
            this.ScoreboardTeam_setSuffix = this.getMethod(this.ScoreboardTeam, "setSuffix", this.IChatBaseComponent);
        } else {
            this.ScoreboardTeam_setPrefix = this.getMethod(this.ScoreboardTeam, new String[]{"setPrefix", "func_96666_b"}, String.class);
            this.ScoreboardTeam_setSuffix = this.getMethod(this.ScoreboardTeam, new String[]{"setSuffix", "func_96662_c"}, String.class);
        }
    }

    @Override
    public void loadClasses() throws ClassNotFoundException {
        this.EntityHuman = this.getLegacyClass("EntityHuman");
        this.World = this.getLegacyClass("World");
        this.Packet = this.getLegacyClass("Packet");
        this.EnumChatFormat = this.getLegacyClass("EnumChatFormat");
        this.EntityPlayer = this.getLegacyClass("EntityPlayer");
        this.Entity = this.getLegacyClass("Entity");
        this.EntityLiving = this.getLegacyClass("EntityLiving");
        this.PlayerConnection = this.getLegacyClass("PlayerConnection");
        this.PacketPlayOutChat = this.getLegacyClass("PacketPlayOutChat", "Packet3Chat");
        this.NetworkManager = this.getLegacyClass("NetworkManager");
        if (this.minorVersion >= 7) {
            this.IChatBaseComponent = this.getLegacyClass("IChatBaseComponent");
            this.ChatSerializer = this.getLegacyClass("IChatBaseComponent$ChatSerializer", "ChatSerializer");
        }
        if (this.minorVersion >= 8) {
            this.PacketPlayOutPlayerListHeaderFooter = this.getLegacyClass("PacketPlayOutPlayerListHeaderFooter");
            this.EntityArmorStand = this.getLegacyClass("EntityArmorStand");
        }
        if (this.minorVersion >= 12) {
            this.ChatMessageType = this.getLegacyClass("ChatMessageType");
        }
        this.DataWatcher = this.getLegacyClass("DataWatcher");
        this.DataWatcherItem = this.getLegacyClass("DataWatcher$Item", "DataWatcher$WatchableObject", "WatchableObject");
        if (this.minorVersion >= 9) {
            this.DataWatcherObject = this.getLegacyClass("DataWatcherObject");
            this.DataWatcherRegistry = this.getLegacyClass("DataWatcherRegistry");
            this.DataWatcherSerializer = this.getLegacyClass("DataWatcherSerializer");
        }
        this.PacketPlayOutSpawnEntityLiving = this.getLegacyClass("PacketPlayOutSpawnEntityLiving", "Packet24MobSpawn");
        this.PacketPlayOutEntityTeleport = this.getLegacyClass("PacketPlayOutEntityTeleport", "Packet34EntityTeleport");
        this.PacketPlayInUseEntity = this.getLegacyClass("PacketPlayInUseEntity", "Packet7UseEntity");
        this.PacketPlayOutEntity = this.getLegacyClass("PacketPlayOutEntity", "Packet30Entity");
        this.PacketPlayOutEntityDestroy = this.getLegacyClass("PacketPlayOutEntityDestroy", "Packet29DestroyEntity");
        this.PacketPlayOutEntityLook = this.getLegacyClass("PacketPlayOutEntity$PacketPlayOutEntityLook", "PacketPlayOutEntityLook", "Packet32EntityLook");
        this.PacketPlayOutEntityMetadata = this.getLegacyClass("PacketPlayOutEntityMetadata", "Packet40EntityMetadata");
        this.PacketPlayOutNamedEntitySpawn = this.getLegacyClass("PacketPlayOutNamedEntitySpawn", "Packet20NamedEntitySpawn");
        if (this.minorVersion >= 7) {
            this.EnumEntityUseAction = this.getLegacyClass("PacketPlayInUseEntity$EnumEntityUseAction", "EnumEntityUseAction");
        }
        if (this.minorVersion >= 8) {
            this.PacketPlayOutPlayerInfo = this.getLegacyClass("PacketPlayOutPlayerInfo");
            this.EnumPlayerInfoAction = this.getLegacyClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction", "EnumPlayerInfoAction");
            this.PlayerInfoData = this.getLegacyClass("PacketPlayOutPlayerInfo$PlayerInfoData", "PlayerInfoData");
            this.EnumGamemode = this.getLegacyClass("EnumGamemode", "WorldSettings$EnumGamemode");
        }
        this.PacketPlayOutScoreboardDisplayObjective = this.getLegacyClass("PacketPlayOutScoreboardDisplayObjective", "Packet208SetScoreboardDisplayObjective");
        this.PacketPlayOutScoreboardObjective = this.getLegacyClass("PacketPlayOutScoreboardObjective", "Packet206SetScoreboardObjective");
        this.PacketPlayOutScoreboardTeam = this.getLegacyClass("PacketPlayOutScoreboardTeam", "Packet209SetScoreboardTeam");
        this.PacketPlayOutScoreboardScore = this.getLegacyClass("PacketPlayOutScoreboardScore", "Packet207SetScoreboardScore");
        this.Scoreboard = this.getLegacyClass("Scoreboard");
        this.ScoreboardObjective = this.getLegacyClass("ScoreboardObjective");
        this.ScoreboardScore = this.getLegacyClass("ScoreboardScore");
        this.IScoreboardCriteria = this.getLegacyClass("IScoreboardCriteria");
        this.ScoreboardTeam = this.getLegacyClass("ScoreboardTeam");
        if (this.minorVersion >= 8) {
            this.EnumScoreboardHealthDisplay = this.getLegacyClass("IScoreboardCriteria$EnumScoreboardHealthDisplay", "EnumScoreboardHealthDisplay");
            this.EnumScoreboardAction = this.getLegacyClass("ScoreboardServer$Action", "PacketPlayOutScoreboardScore$EnumScoreboardAction", "EnumScoreboardAction");
            this.EnumNameTagVisibility = this.getLegacyClass("ScoreboardTeamBase$EnumNameTagVisibility", "EnumNameTagVisibility");
        }
        if (this.minorVersion >= 9) {
            this.EnumTeamPush = this.getLegacyClass("ScoreboardTeamBase$EnumTeamPush");
        }
    }
}

