/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.platforms.bungeecord.BungeePlatform;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeeEventListener
implements Listener {
    private final BungeePlatform platform;

    public BungeeEventListener(BungeePlatform platform) {
        this.platform = platform;
    }

    @EventHandler
    public void onQuit(PlayerDisconnectEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runTask(() -> TabAPI.getInstance().getFeatureManager().onQuit(TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId())));
    }

    @EventHandler
    public void onSwitch(ServerSwitchEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runTask(() -> {
            if (TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId()) == null) {
                TabAPI.getInstance().getFeatureManager().onJoin(new BungeeTabPlayer(e.getPlayer()));
            } else {
                TabAPI.getInstance().getFeatureManager().onServerChange(e.getPlayer().getUniqueId(), e.getPlayer().getServer().getInfo().getName());
            }
        });
    }

    @EventHandler
    public void onChat(ChatEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        if (e.isCommand() && TabAPI.getInstance().getFeatureManager().onCommand(TabAPI.getInstance().getPlayer(((ProxiedPlayer)e.getSender()).getUniqueId()), e.getMessage())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void on(PluginMessageEvent event) {
        if (!event.getTag().equals("tab:bridge-2")) {
            return;
        }
        if (event.getReceiver() instanceof ProxiedPlayer) {
            event.setCancelled(true);
            this.platform.getPluginMessageHandler().onPluginMessage(((ProxiedPlayer)event.getReceiver()).getUniqueId(), event.getData());
        }
    }
}

