/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.RedisBungeeSupport;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PipelineInjector;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.Team;

public class BungeePipelineInjector
extends PipelineInjector {
    private final Class<? extends DefinedPacket>[] extraPacketClasses = new Class[]{Team.class, ScoreboardDisplay.class, ScoreboardObjective.class};
    private final Supplier<DefinedPacket>[] extraPacketSuppliers = new Supplier[]{Team::new, ScoreboardDisplay::new, ScoreboardObjective::new};

    public BungeePipelineInjector() {
        super("inbound-boss");
    }

    @Override
    public Function<TabPlayer, ChannelDuplexHandler> getChannelFunction() {
        return this.byteBufDeserialization ? x$0 -> new DeserializableBungeeChannelDuplexHandler((TabPlayer)x$0) : x$0 -> new BungeeChannelDuplexHandler((TabPlayer)x$0);
    }

    public class BungeeChannelDuplexHandler
    extends ChannelDuplexHandler {
        protected final TabPlayer player;

        public BungeeChannelDuplexHandler(TabPlayer player) {
            this.player = player;
        }

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) {
            try {
                switch (packet.getClass().getSimpleName()) {
                    case "PlayerListItem": {
                        super.write(context, TAB.getInstance().getFeatureManager().onPacketPlayOutPlayerInfo(this.player, packet), channelPromise);
                        return;
                    }
                    case "Team": {
                        if (!BungeePipelineInjector.this.antiOverrideTeams) break;
                        long time = System.nanoTime();
                        this.modifyPlayers((Team)packet);
                        TAB.getInstance().getCPUManager().addTime("NameTags", "Anti override", System.nanoTime() - time);
                        break;
                    }
                    case "ScoreboardDisplay": {
                        TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, packet);
                        break;
                    }
                    case "ScoreboardObjective": {
                        TAB.getInstance().getFeatureManager().onObjective(this.player, packet);
                        break;
                    }
                    case "Login": {
                        super.write(context, packet, channelPromise);
                        TAB.getInstance().getFeatureManager().onLoginPacket(this.player);
                        return;
                    }
                }
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("An error occurred when analyzing packets for player " + this.player.getName() + " with client version " + this.player.getVersion().getFriendlyName(), e);
            }
            try {
                super.write(context, packet, channelPromise);
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError(String.format("Failed to forward packet %s to %s", packet.getClass().getSimpleName(), this.player.getName()), e);
            }
        }

        private void modifyPlayers(Team packet) {
            if (packet.getMode() == 1 || packet.getMode() == 2 || packet.getMode() == 4) {
                return;
            }
            ArrayList col = Lists.newArrayList((Object[])packet.getPlayers());
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!col.contains(p.getNickname()) || ((TabFeature)((Object)TAB.getInstance().getTeamManager())).isDisabledPlayer(p) || TAB.getInstance().getTeamManager().hasTeamHandlingPaused(p) || packet.getName().equals(p.getTeamName())) continue;
                BungeePipelineInjector.this.logTeamOverride(packet.getName(), p.getName(), p.getTeamName());
                col.remove(p.getNickname());
            }
            RedisBungeeSupport redis = (RedisBungeeSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
            if (redis != null) {
                for (RedisPlayer p : redis.getRedisPlayers().values()) {
                    if (!col.contains(p.getNickName()) || packet.getName().equals(p.getTeamName())) continue;
                    BungeePipelineInjector.this.logTeamOverride(packet.getName(), p.getName(), p.getTeamName());
                    col.remove(p.getNickName());
                }
            }
            packet.setPlayers(col.toArray(new String[0]));
        }
    }

    public class DeserializableBungeeChannelDuplexHandler
    extends BungeeChannelDuplexHandler {
        public DeserializableBungeeChannelDuplexHandler(TabPlayer player) {
            super(player);
        }

        @Override
        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) {
            long time = System.nanoTime();
            Object modifiedPacket = packet instanceof ByteBuf ? this.deserialize((ByteBuf)packet) : packet;
            TAB.getInstance().getCPUManager().addTime("Packet deserializing", "ByteBuf", System.nanoTime() - time);
            super.write(context, modifiedPacket, channelPromise);
        }

        private Object deserialize(ByteBuf buf) {
            int marker = buf.readerIndex();
            try {
                byte packetId = buf.readByte();
                for (int i = 0; i < BungeePipelineInjector.this.extraPacketClasses.length; ++i) {
                    if (packetId != ((BungeeTabPlayer)this.player).getPacketId(BungeePipelineInjector.this.extraPacketClasses[i])) continue;
                    DefinedPacket packet = (DefinedPacket)BungeePipelineInjector.this.extraPacketSuppliers[i].get();
                    packet.read(buf, null, ((ProxiedPlayer)this.player.getPlayer()).getPendingConnection().getVersion());
                    buf.release();
                    return packet;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.readerIndex(marker);
            return buf;
        }
    }
}

