/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import me.neznamy.tab.platforms.bungeecord.BungeePacketBuilder;
import me.neznamy.tab.platforms.bungeecord.BungeePipelineInjector;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.RedisBungeeSupport;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlatform
extends ProxyPlatform {
    public BungeePlatform() {
        super(new BungeePacketBuilder());
    }

    @Override
    public void loadFeatures() {
        TAB tab = TAB.getInstance();
        if (tab.getConfiguration().isPipelineInjection()) {
            tab.getFeatureManager().registerFeature("injection", new BungeePipelineInjector());
        }
        tab.getPlaceholderManager().registerPlayerPlaceholder("%displayname%", 500, p -> ((ProxiedPlayer)p.getPlayer()).getDisplayName());
        super.loadFeatures();
        if (ProxyServer.getInstance().getPluginManager().getPlugin("RedisBungee") != null) {
            if (RedisBungeeAPI.getRedisBungeeApi() != null) {
                tab.getFeatureManager().registerFeature("RedisBungee", new RedisBungeeSupport());
            } else {
                TAB.getInstance().getErrorManager().criticalError("RedisBungee plugin was detected, but it returned null API instance. Disabling hook.", null);
            }
        }
        for (ProxiedPlayer p2 : ProxyServer.getInstance().getPlayers()) {
            tab.addPlayer(new BungeeTabPlayer(p2));
        }
    }

    @Override
    public String getPluginVersion(String plugin) {
        Plugin pl = ProxyServer.getInstance().getPluginManager().getPlugin(plugin);
        return pl == null ? null : pl.getDescription().getVersion();
    }
}

