/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.libs.org.bstats.velocity.Metrics;
import me.neznamy.tab.platforms.velocity.VelocityEventListener;
import me.neznamy.tab.platforms.velocity.VelocityPlatform;
import me.neznamy.tab.shared.TAB;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.slf4j.Logger;

public class Main {
    private static Main instance;
    @Inject
    private ProxyServer server;
    @Inject
    private Metrics.Factory metricsFactory;
    @Inject
    private Logger logger;
    private final MinecraftChannelIdentifier mc = MinecraftChannelIdentifier.create((String)"tab:bridge-2".split(":")[0], (String)"tab:bridge-2".split(":")[1]);
    private final Map<IChatBaseComponent, Component> componentCacheModern = new HashMap<IChatBaseComponent, Component>();
    private final Map<IChatBaseComponent, Component> componentCacheLegacy = new HashMap<IChatBaseComponent, Component>();
    private final VelocityPlatform platform = new VelocityPlatform();

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        if (this.server.getConfiguration().isOnlineMode()) {
            this.logger.info(EnumChatFormat.color("&6If you experience tablist prefix/suffix not working and global playerlist duplicating players, toggle \"use-online-uuid-in-tablist\" option in config.yml (set it to opposite value)."));
        }
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{this.mc});
        TAB.setInstance(new TAB(this.platform, ProtocolVersion.PROXY, this.server.getVersion().getVersion(), new File("plugins" + File.separatorChar + "TAB"), this.logger));
        this.server.getEventManager().register((Object)this, (Object)new VelocityEventListener());
        VelocityTABCommand cmd = new VelocityTABCommand();
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("btab").build(), (Command)cmd);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("vtab").build(), (Command)cmd);
        TAB.getInstance().load();
        Metrics metrics = this.metricsFactory.make(this, 10533);
        metrics.addCustomChart(new SimplePie("global_playerlist_enabled", () -> TabAPI.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    public static Main getInstance() {
        return instance;
    }

    public VelocityPlatform getPlatform() {
        return this.platform;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public MinecraftChannelIdentifier getMinecraftChannelIdentifier() {
        return this.mc;
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        TAB.getInstance().unload();
    }

    public Component convertComponent(IChatBaseComponent component, ProtocolVersion clientVersion) {
        if (component == null) {
            return null;
        }
        return clientVersion.getMinorVersion() >= 16 ? this.fromCache(this.componentCacheModern, component, clientVersion) : this.fromCache(this.componentCacheLegacy, component, clientVersion);
    }

    private Component fromCache(Map<IChatBaseComponent, Component> map, IChatBaseComponent component, ProtocolVersion clientVersion) {
        if (map.containsKey(component)) {
            return map.get(component);
        }
        Component obj = GsonComponentSerializer.gson().deserialize((Object)component.toString(clientVersion));
        if (map.size() > 10000) {
            map.clear();
        }
        map.put(component, obj);
        return obj;
    }

    private static class VelocityTABCommand
    implements SimpleCommand {
        private VelocityTABCommand() {
        }

        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource sender = invocation.source();
            if (TabAPI.getInstance().isPluginDisabled()) {
                for (String message : TAB.getInstance().getDisabledCommand().execute((String[])invocation.arguments(), sender.hasPermission("tab.reload"), sender.hasPermission("tab.admin"))) {
                    sender.sendMessage(Identity.nil(), (Component)Component.text((String)EnumChatFormat.color(message)));
                }
            } else {
                TabPlayer p = null;
                if (sender instanceof Player && (p = TabAPI.getInstance().getPlayer(((Player)sender).getUniqueId())) == null) {
                    return;
                }
                TAB.getInstance().getCommand().execute(p, (String[])invocation.arguments());
            }
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            TabPlayer p = null;
            if (invocation.source() instanceof Player && (p = TabAPI.getInstance().getPlayer(((Player)invocation.source()).getUniqueId())) == null) {
                return new ArrayList<String>();
            }
            return TAB.getInstance().getCommand().complete(p, (String[])invocation.arguments());
        }
    }
}

