/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.task.ThreadManager;
import me.neznamy.tab.shared.TAB;

public class CpuManager
implements ThreadManager {
    private final int BUFFER_SIZE_MILLIS = 10000;
    private Map<String, Map<String, AtomicLong>> featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
    private Map<String, AtomicLong> placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> methodUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> packetsCurrent = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, Map<String, AtomicLong>> featureUsagePrevious = new HashMap<String, Map<String, AtomicLong>>();
    private Map<String, AtomicLong> placeholderUsagePrevious = new HashMap<String, AtomicLong>();
    private Map<String, AtomicLong> methodUsagePrevious = new HashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> packetsPrevious = new ConcurrentHashMap<String, AtomicInteger>();
    private ExecutorService thread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Processing Thread").build());
    private final ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(20, new ThreadFactoryBuilder().setNameFormat("TAB Repeating / Delayed Thread %d").build());
    private final List<Runnable> taskQueue = new ArrayList<Runnable>();
    private boolean enabled = false;

    public CpuManager() {
        this.startRepeatingTask(10000, () -> {
            this.featureUsagePrevious = this.featureUsageCurrent;
            this.placeholderUsagePrevious = this.placeholderUsageCurrent;
            this.methodUsagePrevious = this.methodUsageCurrent;
            this.packetsPrevious = this.packetsCurrent;
            this.featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
            this.placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
            this.methodUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
            this.packetsCurrent = new ConcurrentHashMap<String, AtomicInteger>();
        });
    }

    public void cancelAllTasks() {
        ExecutorService old = this.thread;
        this.thread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Processing Thread").build());
        old.shutdownNow();
        this.threadPool.shutdownNow();
    }

    public void enable() {
        this.enabled = true;
        this.taskQueue.forEach(this::submit);
        this.taskQueue.clear();
    }

    private Future<Void> submit(Runnable task) {
        if (!this.enabled) {
            this.taskQueue.add(task);
            return null;
        }
        return this.thread.submit(() -> {
            try {
                task.run();
            }
            catch (Exception | LinkageError | StackOverflowError e) {
                TAB.getInstance().getErrorManager().printError("An error was thrown when executing task", e);
            }
        });
    }

    public Map<String, Float> getPlaceholderUsage() {
        return this.getUsage(this.placeholderUsagePrevious);
    }

    public Map<String, Float> getMethodUsage() {
        return this.getUsage(this.methodUsagePrevious);
    }

    public Map<String, AtomicInteger> getSentPackets() {
        return this.sortByValue1(this.packetsPrevious);
    }

    private Map<String, Float> getUsage(Map<String, AtomicLong> map) {
        HashMap<String, Long> nanoMap = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> nanos : map.entrySet()) {
            String key = nanos.getKey();
            nanoMap.putIfAbsent(key, 0L);
            nanoMap.put(key, (Long)nanoMap.get(key) + nanos.getValue().get());
        }
        HashMap<String, Float> percentMap = new HashMap<String, Float>();
        for (Map.Entry entry : nanoMap.entrySet()) {
            percentMap.put((String)entry.getKey(), Float.valueOf(this.nanosToPercent((Long)entry.getValue())));
        }
        return this.sortByValue(percentMap);
    }

    public Map<String, Map<String, Float>> getFeatureUsage() {
        HashMap total = new HashMap();
        for (Map.Entry<String, Map<String, AtomicLong>> nanos : this.featureUsagePrevious.entrySet()) {
            String key = nanos.getKey();
            total.putIfAbsent(key, new HashMap());
            Map usage = (Map)total.get(key);
            for (Map.Entry<String, AtomicLong> entry : nanos.getValue().entrySet()) {
                usage.putIfAbsent(entry.getKey(), 0L);
                usage.put(entry.getKey(), (Long)usage.get(entry.getKey()) + entry.getValue().get());
            }
        }
        LinkedHashMap<String, Map<String, Float>> sorted = new LinkedHashMap<String, Map<String, Float>>();
        for (String key : this.sortKeys(total)) {
            Map local = this.sortByValue((Map)total.get(key));
            LinkedHashMap<String, Float> percent = new LinkedHashMap<String, Float>();
            for (Map.Entry entry : local.entrySet()) {
                percent.put((String)entry.getKey(), Float.valueOf(this.nanosToPercent((Long)entry.getValue())));
            }
            sorted.put(key, percent);
        }
        return sorted;
    }

    private float nanosToPercent(long nanos) {
        float percent = (float)nanos / 10000.0f / 1000000.0f;
        return percent *= 100.0f;
    }

    private <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        Comparator valueComparator = (k1, k2) -> {
            int diff = ((Comparable)map.get(k2)).compareTo((Comparable)map.get(k1));
            return diff == 0 ? 1 : diff;
        };
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private <K> Map<K, AtomicInteger> sortByValue1(Map<K, AtomicInteger> map) {
        Comparator valueComparator = (k1, k2) -> {
            int diff = ((AtomicInteger)map.get(k2)).get() - ((AtomicInteger)map.get(k1)).get();
            return diff == 0 ? 1 : diff;
        };
        TreeMap<K, AtomicInteger> sortedByValues = new TreeMap<K, AtomicInteger>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private <K> List<K> sortKeys(Map<K, Map<String, Long>> map) {
        LinkedHashMap<K, Long> simplified = new LinkedHashMap<K, Long>();
        for (Map.Entry<K, Map<String, Long>> entry : map.entrySet()) {
            simplified.put(entry.getKey(), entry.getValue().values().stream().mapToLong(Long::longValue).sum());
        }
        return new ArrayList(this.sortByValue(simplified).keySet());
    }

    public void addTime(TabFeature feature, String type, long nanoseconds) {
        this.addTime(feature.getFeatureName(), type, nanoseconds);
    }

    public void addTime(String feature, String type, long nanoseconds) {
        this.featureUsageCurrent.computeIfAbsent(feature, f -> new ConcurrentHashMap()).computeIfAbsent(type, t -> new AtomicLong()).addAndGet(nanoseconds);
    }

    private void addTime(Map<String, AtomicLong> map, String key, long time) {
        map.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(time);
    }

    public void addPlaceholderTime(String placeholder, long nanoseconds) {
        this.addTime(this.placeholderUsageCurrent, placeholder, nanoseconds);
    }

    public void addMethodTime(String method, long nanoseconds) {
        this.addTime(this.methodUsageCurrent, method, nanoseconds);
    }

    public void packetSent(String feature) {
        this.packetsCurrent.computeIfAbsent(feature, f -> new AtomicInteger()).incrementAndGet();
    }

    @Override
    public Future<Void> runMeasuredTask(TabFeature feature, String type, Runnable task) {
        return this.runMeasuredTask(feature.getFeatureName(), type, task);
    }

    @Override
    public Future<Void> runMeasuredTask(String feature, String type, Runnable task) {
        return this.submit(() -> {
            long time = System.nanoTime();
            task.run();
            this.addTime(feature, type, System.nanoTime() - time);
        });
    }

    @Override
    public Future<Void> runTask(Runnable task) {
        return this.submit(task);
    }

    @Override
    public Future<?> startRepeatingMeasuredTask(int intervalMilliseconds, TabFeature feature, String type, Runnable task) {
        return this.threadPool.scheduleAtFixedRate(() -> this.runMeasuredTask(feature, type, task), 0L, intervalMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> startRepeatingTask(int intervalMilliseconds, Runnable task) {
        return this.threadPool.scheduleAtFixedRate(() -> this.runTask(task), 0L, intervalMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> runTaskLater(int delayMilliseconds, TabFeature feature, String type, Runnable task) {
        return this.threadPool.schedule(() -> this.runMeasuredTask(feature, type, task), (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> runTaskLater(int delayMilliseconds, Runnable task) {
        return this.threadPool.schedule(() -> this.submit(task), (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }
}

