/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;

public class ErrorManager {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss - ");
    private final File errorLog = new File(TAB.getInstance().getDataFolder(), "errors.log");
    private final File antiOverrideLog = new File(TAB.getInstance().getDataFolder(), "anti-override.log");
    private final File placeholderErrorLog = new File(TAB.getInstance().getDataFolder(), "placeholder-errors.log");

    public void printError(String message) {
        this.printError(message, null, false);
    }

    public void printError(String message, Throwable t) {
        this.printError(message, t, false);
    }

    public void printError(String message, Throwable t, boolean intoConsoleToo) {
        this.printError(message, t, intoConsoleToo, this.errorLog);
    }

    public void printError(String message, Throwable t, boolean intoConsoleToo, File file) {
        Throwable error = t;
        if (error instanceof InvocationTargetException) {
            error = error.getCause();
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (error != null) {
            lines.add(error.getClass().getName() + ": " + error.getMessage());
            for (StackTraceElement ste : error.getStackTrace()) {
                lines.add("\tat " + ste.toString());
            }
        }
        this.printError(message, lines, intoConsoleToo, file);
    }

    private synchronized void printError(String message, List<String> error, boolean intoConsoleToo, File file) {
        try {
            if (!file.exists()) {
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            try (BufferedWriter buf = new BufferedWriter(new FileWriter(file, true));){
                if (message != null) {
                    if (file.length() < 1000000L) {
                        buf.write(this.dateFormat.format(new Date()) + IChatBaseComponent.fromColoredText("&c[TAB v3.1.4] ").toRawText() + EnumChatFormat.decolor(message) + System.getProperty("line.separator"));
                    }
                    if (intoConsoleToo || TAB.getInstance().getConfiguration().isDebugMode()) {
                        TAB.getInstance().sendConsoleMessage(EnumChatFormat.color("&c[TAB v3.1.4] ") + EnumChatFormat.decolor(message), false);
                    }
                }
                for (String line : error) {
                    if (file.length() < 1000000L) {
                        buf.write(this.dateFormat.format(new Date()) + IChatBaseComponent.fromColoredText("&c").toRawText() + line + System.getProperty("line.separator"));
                    }
                    if (!intoConsoleToo && !TAB.getInstance().getConfiguration().isDebugMode()) continue;
                    TAB.getInstance().sendConsoleMessage(EnumChatFormat.color("&c") + line, false);
                }
            }
        }
        catch (IOException ex) {
            TAB.getInstance().sendConsoleMessage("&cAn error occurred when printing error message into file", true);
            TAB.getInstance().sendConsoleMessage(ex.getClass().getName() + ": " + ex.getMessage(), true);
            for (StackTraceElement e : ex.getStackTrace()) {
                TAB.getInstance().sendConsoleMessage("\t" + e.toString(), true);
            }
            TAB.getInstance().sendConsoleMessage("&cOriginal error: " + message, true);
            for (String line : error) {
                TAB.getInstance().sendConsoleMessage(line, true);
            }
        }
    }

    public void placeholderError(String message, Throwable t) {
        this.printError(message, t, false, this.placeholderErrorLog);
    }

    public void placeholderError(String message, List<String> t) {
        this.printError(message, t, false, this.placeholderErrorLog);
    }

    public void criticalError(String message, Throwable t) {
        this.printError(message, t, true);
    }

    public int parseInteger(String string, int defaultValue) {
        try {
            return (int)Math.round(Double.parseDouble(string));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float parseFloat(String string, float defaultValue) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double parseDouble(String string, double defaultValue) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int fixAnimationInterval(String name, int interval) {
        if (interval == 0) {
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of 0 milliseconds! Did you forget to configure it? &bUsing 1000.", name));
            return 1000;
        }
        if (interval < 0) {
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of %s. Refresh cannot be negative! &bUsing 1000.", name, interval));
            return 1000;
        }
        if (interval % 50 != 0) {
            int newInterval = interval - interval % 50;
            if (newInterval == 0) {
                newInterval = 50;
            }
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of %s which is not divisible by 50! &bUsing %s.", name, interval, newInterval));
            return newInterval;
        }
        return interval;
    }

    public List<String> fixAnimationFrames(String name, List<String> list) {
        if (list == null) {
            this.startupWarn("Animation \"&e" + name + "&c\" does not have any texts! &bIgnoring.");
            return Collections.singletonList("<Invalid Animation>");
        }
        return list;
    }

    public void startupWarn(String message) {
        TAB.getInstance().sendConsoleMessage("&c" + message, true);
    }

    public void missingAttribute(String objectType, Object objectName, String attribute) {
        this.startupWarn(objectType + " \"&e" + objectName + "&c\" is missing \"&e" + attribute + "&c\" attribute!");
    }

    public File getAntiOverrideLog() {
        return this.antiOverrideLog;
    }
}

