/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.FeatureManager;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import me.neznamy.tab.shared.proxy.PluginMessageHandler;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;

public class FeatureManagerImpl
implements FeatureManager {
    private final Map<String, TabFeature> features = new LinkedHashMap<String, TabFeature>();
    private TabFeature[] values = new TabFeature[0];
    private boolean objectiveListeners = false;
    private boolean displayObjectiveListeners = false;

    public void load() {
        for (TabFeature f : this.values) {
            f.load();
        }
        if (TAB.getInstance().getConfiguration().getUsers() instanceof MySQLUserConfiguration) {
            MySQLUserConfiguration users = (MySQLUserConfiguration)TAB.getInstance().getConfiguration().getUsers();
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                users.load(p);
            }
        }
    }

    public void unload() {
        for (TabFeature f : this.values) {
            f.unload();
        }
        if (TAB.getInstance().getPlatform() instanceof ProxyPlatform) {
            PluginMessageHandler plm = ((ProxyPlatform)TAB.getInstance().getPlatform()).getPluginMessageHandler();
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                plm.sendMessage(player, "Unload");
            }
        }
    }

    public void refresh(TabPlayer refreshed, boolean force) {
        for (TabFeature f : this.values) {
            f.refresh(refreshed, force);
        }
    }

    public Object onPacketPlayOutPlayerInfo(TabPlayer receiver, Object packet) throws ReflectiveOperationException {
        if (receiver.getVersion().getMinorVersion() < 8) {
            return packet;
        }
        long time = System.nanoTime();
        PacketPlayOutPlayerInfo info = TAB.getInstance().getPlatform().getPacketBuilder().readPlayerInfo(packet, receiver.getVersion());
        TAB.getInstance().getCPUManager().addTime("Packet deserializing", "PacketPlayOutPlayerInfo", System.nanoTime() - time);
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onPlayerInfo")) continue;
            time = System.nanoTime();
            f.onPlayerInfo(receiver, info);
            TAB.getInstance().getCPUManager().addTime(f, "PacketPlayOutPlayerInfo", System.nanoTime() - time);
        }
        time = System.nanoTime();
        Object pack = TAB.getInstance().getPlatform().getPacketBuilder().build(info, receiver.getVersion());
        TAB.getInstance().getCPUManager().addTime("Packet serializing", "PacketPlayOutPlayerInfo", System.nanoTime() - time);
        return pack;
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        if (disconnectedPlayer == null) {
            return;
        }
        long millis = System.currentTimeMillis();
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onQuit")) continue;
            long time = System.nanoTime();
            f.onQuit(disconnectedPlayer);
            TAB.getInstance().getCPUManager().addTime(f, "Player Quit", System.nanoTime() - time);
        }
        TAB.getInstance().removePlayer(disconnectedPlayer);
        TAB.getInstance().debug("Player quit of " + disconnectedPlayer.getName() + " processed in " + (System.currentTimeMillis() - millis) + "ms");
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (!connectedPlayer.isOnline()) {
            return;
        }
        long millis = System.currentTimeMillis();
        TAB.getInstance().addPlayer(connectedPlayer);
        for (TabFeature f : this.values) {
            try {
                if (!f.overridesMethod("onJoin")) continue;
                long time = System.nanoTime();
                f.onJoin(connectedPlayer);
                TAB.getInstance().getCPUManager().addTime(f, "Player Join", System.nanoTime() - time);
                TAB.getInstance().debug("Feature " + f.getClass().getSimpleName() + " processed player join in " + (System.nanoTime() - time) / 1000000L + "ms");
            }
            catch (Throwable e) {
                TAB.getInstance().getErrorManager().criticalError("Feature " + f.getClass().getSimpleName() + " failed to process player " + connectedPlayer.getName(), e);
            }
        }
        ((ITabPlayer)connectedPlayer).markAsLoaded(true);
        TAB.getInstance().debug("Player join of " + connectedPlayer.getName() + " processed in " + (System.currentTimeMillis() - millis) + "ms");
        if (TAB.getInstance().getConfiguration().getUsers() instanceof MySQLUserConfiguration) {
            MySQLUserConfiguration users = (MySQLUserConfiguration)TAB.getInstance().getConfiguration().getUsers();
            users.load(connectedPlayer);
        }
    }

    @Override
    public void onWorldChange(UUID playerUUID, String to) {
        TabPlayer changed = TAB.getInstance().getPlayer(playerUUID);
        if (changed == null) {
            return;
        }
        String from = changed.getWorld();
        ((ITabPlayer)changed).setWorld(to);
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onWorldChange")) continue;
            long time = System.nanoTime();
            f.onWorldChange(changed, from, to);
            TAB.getInstance().getCPUManager().addTime(f, "World Switch", System.nanoTime() - time);
        }
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%world%"))).updateValue(changed, to);
    }

    @Override
    public void onServerChange(UUID playerUUID, String to) {
        TabPlayer changed = TAB.getInstance().getPlayer(playerUUID);
        if (changed == null) {
            return;
        }
        String from = changed.getServer();
        ((ITabPlayer)changed).setServer(to);
        ((ProxyTabPlayer)changed).sendJoinPluginMessage();
        if (!this.isFeatureEnabled("injection")) {
            this.onLoginPacket(changed);
        }
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onServerChange")) continue;
            long time = System.nanoTime();
            f.onServerChange(changed, from, to);
            TAB.getInstance().getCPUManager().addTime(f, "Server Switch", System.nanoTime() - time);
        }
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%server%"))).updateValue(changed, to);
    }

    @Override
    public boolean onCommand(TabPlayer sender, String command) {
        if (sender == null) {
            return false;
        }
        boolean cancel = false;
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onCommand")) continue;
            long time = System.nanoTime();
            if (f.onCommand(sender, command)) {
                cancel = true;
            }
            TAB.getInstance().getCPUManager().addTime(f, "Command Preprocess", System.nanoTime() - time);
        }
        return cancel;
    }

    @Override
    public void markObjective() {
        this.objectiveListeners = true;
    }

    @Override
    public void markDisplayObjective() {
        this.displayObjectiveListeners = true;
    }

    public boolean onPacketReceive(TabPlayer sender, Object packet) {
        boolean cancel = false;
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onPacketReceive")) continue;
            long time = System.nanoTime();
            try {
                cancel = f.onPacketReceive(sender, packet);
            }
            catch (ReflectiveOperationException e) {
                TAB.getInstance().getErrorManager().printError("Feature " + f.getFeatureName() + " failed to read packet", e);
            }
            TAB.getInstance().getCPUManager().addTime(f, "Packet reading (in)", System.nanoTime() - time);
        }
        return cancel;
    }

    public void onPacketSend(TabPlayer receiver, Object packet) {
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onPacketSend")) continue;
            long time = System.nanoTime();
            try {
                f.onPacketSend(receiver, packet);
            }
            catch (ReflectiveOperationException e) {
                TAB.getInstance().getErrorManager().printError("Feature " + f.getFeatureName() + " failed to read packet", e);
            }
            TAB.getInstance().getCPUManager().addTime(f, "Packet reading (out)", System.nanoTime() - time);
        }
    }

    public void onLoginPacket(TabPlayer packetReceiver) {
        ((ITabPlayer)packetReceiver).clearRegisteredObjectives();
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onLoginPacket")) continue;
            long time = System.nanoTime();
            f.onLoginPacket(packetReceiver);
            TAB.getInstance().getCPUManager().addTime(f, "Login Packet", System.nanoTime() - time);
        }
    }

    public void onDisplayObjective(TabPlayer packetReceiver, Object packet) throws ReflectiveOperationException {
        if (!this.displayObjectiveListeners) {
            return;
        }
        long time = System.nanoTime();
        PacketPlayOutScoreboardDisplayObjective display = TAB.getInstance().getPlatform().getPacketBuilder().readDisplayObjective(packet);
        TAB.getInstance().getCPUManager().addTime("Packet deserializing", "PacketPlayOutScoreboardDisplayObjective", System.nanoTime() - time);
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onDisplayObjective")) continue;
            time = System.nanoTime();
            f.onDisplayObjective(packetReceiver, display);
            TAB.getInstance().getCPUManager().addTime(f, "Anti override", System.nanoTime() - time);
        }
    }

    public void onObjective(TabPlayer packetReceiver, Object packet) throws ReflectiveOperationException {
        if (!this.objectiveListeners) {
            return;
        }
        long time = System.nanoTime();
        PacketPlayOutScoreboardObjective display = TAB.getInstance().getPlatform().getPacketBuilder().readObjective(packet);
        TAB.getInstance().getCPUManager().addTime("Packet deserializing", "PacketPlayOutScoreboardObjective", System.nanoTime() - time);
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onObjective")) continue;
            time = System.nanoTime();
            f.onObjective(packetReceiver, display);
            TAB.getInstance().getCPUManager().addTime(f, "Anti override", System.nanoTime() - time);
        }
    }

    public void onVanishStatusChange(TabPlayer player) {
        for (TabFeature f : this.values) {
            if (!f.overridesMethod("onVanishStatusChange")) continue;
            long time = System.nanoTime();
            f.onVanishStatusChange(player);
            TAB.getInstance().getCPUManager().addTime(f, "Vanish status change", System.nanoTime() - time);
        }
    }

    @Override
    public void registerFeature(String featureName, TabFeature featureHandler) {
        this.features.put(featureName, featureHandler);
        this.values = this.features.values().toArray(new TabFeature[0]);
    }

    @Override
    public void unregisterFeature(String featureName) {
        this.features.remove(featureName);
        this.values = this.features.values().toArray(new TabFeature[0]);
    }

    @Override
    public boolean isFeatureEnabled(String name) {
        return this.features.containsKey(name);
    }

    @Override
    public TabFeature getFeature(String name) {
        return this.features.get(name);
    }

    @Override
    public TabFeature[] getValues() {
        return this.values;
    }
}

