/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.shared.DynamicText;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;

public class ParseCommand
extends SubCommand {
    public ParseCommand() {
        super("parse", "tab.parse");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        TabPlayer target;
        if (args.length < 2) {
            this.sendMessage(sender, this.getMessages().getParseCommandUsage());
            return;
        }
        if (args[0].equals("me") && sender != null) {
            target = sender;
        } else {
            target = TAB.getInstance().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
                return;
            }
        }
        String replaced = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String message = EnumChatFormat.color("&6Replacing placeholder &e%placeholder% &6for player &e" + target.getName()).replace("%placeholder%", replaced);
        this.sendRawMessage(sender, message);
        try {
            replaced = new DynamicText(null, null, target, replaced, null).get();
        }
        catch (Exception e) {
            this.sendMessage(sender, "&cThe placeholder threw an exception when parsing. Check console for more info.");
            TAB.getInstance().getErrorManager().printError("Placeholder " + replaced + " threw an exception when parsing for player " + target.getName(), e, true);
            return;
        }
        IChatBaseComponent colored = IChatBaseComponent.optimizedComponent("With colors: " + replaced);
        if (sender != null) {
            sender.sendMessage(colored);
        } else {
            this.sendRawMessage(null, colored.toLegacyText());
        }
        this.sendRawMessage(sender, "Without colors: " + EnumChatFormat.decolor(replaced));
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        if (arguments.length == 1) {
            List<String> suggestions = this.getOnlinePlayers(arguments[0]);
            if ("me".startsWith(arguments[0].toLowerCase())) {
                suggestions.add("me");
            }
            return suggestions;
        }
        if (arguments.length == 2) {
            return TAB.getInstance().getPlaceholderManager().getAllPlaceholders().stream().map(Placeholder::getIdentifier).filter(placeholder -> placeholder.toLowerCase().startsWith(arguments[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

