/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;

public class ScoreboardCommand
extends SubCommand {
    public ScoreboardCommand() {
        super("scoreboard", null);
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        ScoreboardManagerImpl scoreboard = this.getScoreboardManager();
        if (scoreboard == null) {
            this.sendMessage(sender, "&cScoreboard feature is not enabled, therefore toggle command cannot be used.");
            return;
        }
        if (args.length == 0) {
            this.toggle(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("show")) {
            this.show(sender, args);
            return;
        }
        TabPlayer p = this.getTarget(sender, args);
        if (p == null) {
            return;
        }
        if (scoreboard.getOtherPluginScoreboards().containsKey(p)) {
            return;
        }
        boolean silent = args.length >= 3 && args[2].equals("-s");
        switch (args[0]) {
            case "on": {
                scoreboard.setScoreboardVisible(p, true, !silent);
                break;
            }
            case "off": {
                scoreboard.setScoreboardVisible(p, false, !silent);
                break;
            }
            case "toggle": {
                scoreboard.toggleScoreboard(p, !silent);
                break;
            }
        }
    }

    private void toggle(TabPlayer sender) {
        if (sender == null) {
            this.sendMessage(null, this.getMessages().getCommandOnlyFromGame());
            return;
        }
        if (sender.hasPermission("tab.scoreboard.toggle")) {
            ScoreboardManagerImpl scoreboard = this.getScoreboardManager();
            if (scoreboard.getOtherPluginScoreboards().containsKey(sender)) {
                return;
            }
            scoreboard.toggleScoreboard(sender, true);
        } else {
            sender.sendMessage(this.getMessages().getNoPermission(), true);
        }
    }

    private void show(TabPlayer sender, String[] args) {
        TabPlayer target;
        if (args.length < 2) {
            this.sendMessage(sender, this.getMessages().getScoreboardShowUsage());
            return;
        }
        ScoreboardManagerImpl scoreboard = this.getScoreboardManager();
        Scoreboard sb = scoreboard.getRegisteredScoreboards().get(args[1]);
        if (sb == null) {
            this.sendMessage(sender, this.getMessages().getScoreboardNotFound(args[1]));
            return;
        }
        if (args.length == 2) {
            if (!this.hasPermission(sender, "tab.scoreboard.show")) {
                this.sendMessage(sender, this.getMessages().getNoPermission());
                return;
            }
            if (sender == null) {
                this.sendMessage(sender, this.getMessages().getCommandOnlyFromGame());
                return;
            }
            target = sender;
        } else {
            if (!this.hasPermission(sender, "tab.scoreboard.show.other")) {
                this.sendMessage(sender, this.getMessages().getNoPermission());
                return;
            }
            target = TAB.getInstance().getPlayer(args[2]);
            if (target == null) {
                this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[2]));
                return;
            }
        }
        scoreboard.showScoreboard(target, sb);
    }

    private TabPlayer getTarget(TabPlayer sender, String[] args) {
        if (args.length >= 2 && TAB.getInstance().getPlayer(args[1]) != null) {
            if (this.hasPermission(sender, "tab.scoreboard.toggle.other")) {
                return TAB.getInstance().getPlayer(args[1]);
            }
            this.sendMessage(sender, this.getMessages().getNoPermission());
        } else {
            if (this.hasPermission(sender, "tab.scoreboard.toggle")) {
                return sender;
            }
            this.sendMessage(sender, this.getMessages().getNoPermission());
        }
        return null;
    }

    private ScoreboardManagerImpl getScoreboardManager() {
        return (ScoreboardManagerImpl)TAB.getInstance().getFeatureManager().getFeature("ScoreBoard");
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        ScoreboardManagerImpl scoreboard = this.getScoreboardManager();
        if (scoreboard == null) {
            return new ArrayList<String>();
        }
        if (arguments.length == 1) {
            return this.getStartingArgument(Arrays.asList("on", "off", "toggle", "show"), arguments[0]);
        }
        if (arguments.length == 2) {
            return arguments[0].equalsIgnoreCase("show") ? this.getStartingArgument(scoreboard.getRegisteredScoreboards().keySet(), arguments[1]) : this.getOnlinePlayers(arguments[1]);
        }
        if (arguments.length == 3) {
            return arguments[0].equalsIgnoreCase("show") ? this.getOnlinePlayers(arguments[2]) : this.getStartingArgument(Collections.singletonList("-s"), arguments[2]);
        }
        return new ArrayList<String>();
    }
}

