/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.MessageFile;

public abstract class SubCommand {
    private static String[] allProperties = new String[]{"tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "abovename", "belowname", "customtagname"};
    protected final List<String> extraProperties = Arrays.asList("abovename", "belowname", "customtagname");
    private final String name;
    private final String permission;
    private final Map<String, SubCommand> subcommands = new HashMap<String, SubCommand>();

    protected SubCommand(String name, String permission) {
        this.name = name;
        this.permission = permission;
    }

    public void registerSubCommand(SubCommand subcommand) {
        this.getSubcommands().put(subcommand.getName(), subcommand);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPermission(TabPlayer sender) {
        return this.hasPermission(sender, this.permission);
    }

    public boolean hasPermission(TabPlayer sender, String permission) {
        if (permission == null) {
            return true;
        }
        if (sender == null) {
            return true;
        }
        if (sender.hasPermission("tab.admin")) {
            return true;
        }
        return sender.hasPermission(permission);
    }

    public void sendMessages(TabPlayer sender, List<String> messages) {
        messages.forEach(m -> this.sendMessage(sender, (String)m));
    }

    public void sendMessage(TabPlayer sender, String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (sender != null) {
            sender.sendMessage(message, true);
        } else {
            TAB.getInstance().sendConsoleMessage(message, true);
        }
    }

    public void sendRawMessage(TabPlayer sender, String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (sender != null) {
            sender.sendMessage(message, false);
        } else {
            TAB.getInstance().sendConsoleMessage(message, false);
        }
    }

    public List<String> getOnlinePlayers(String nameStart) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!all.getName().toLowerCase().startsWith(nameStart.toLowerCase())) continue;
            suggestions.add(all.getName());
        }
        return suggestions;
    }

    public List<String> getStartingArgument(Collection<String> values, String argument) {
        return values.stream().filter(value -> value.toLowerCase().startsWith(argument.toLowerCase())).collect(Collectors.toList());
    }

    public List<String> complete(TabPlayer sender, String[] arguments) {
        String argument = arguments.length == 0 ? "" : arguments[0].toLowerCase();
        if (arguments.length < 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String subcommand : this.getSubcommands().keySet()) {
                if (!subcommand.startsWith(argument)) continue;
                suggestions.add(subcommand);
            }
            return suggestions;
        }
        SubCommand subcommand = this.getSubcommands().get(argument);
        if (subcommand != null) {
            return subcommand.complete(sender, Arrays.copyOfRange(arguments, 1, arguments.length));
        }
        return new ArrayList<String>();
    }

    public MessageFile getMessages() {
        return TAB.getInstance().getConfiguration().getMessages();
    }

    public abstract void execute(TabPlayer var1, String[] var2);

    public static String[] getAllProperties() {
        return allProperties;
    }

    public static void setAllProperties(String[] allProperties) {
        SubCommand.allProperties = allProperties;
    }

    public Map<String, SubCommand> getSubcommands() {
        return this.subcommands;
    }
}

