/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;

public class WidthCheckCommand
extends SubCommand {
    private final byte[] widths = this.loadWidths();

    public WidthCheckCommand() {
        super("widthcheck", "tab.width");
    }

    private byte[] loadWidths() {
        byte[] widths = new byte[65536];
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("widths.txt");
        if (file == null) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load widths.txt file. Is it inside the jar? Aligned suffix will not work.", null);
            return widths;
        }
        int characterId = 1;
        for (String line : new BufferedReader(new InputStreamReader(file)).lines().collect(Collectors.toList())) {
            widths[characterId++] = (byte)Float.parseFloat(line);
        }
        Map widthOverrides = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("tablist-name-formatting.character-width-overrides");
        for (Map.Entry entry : widthOverrides.entrySet()) {
            widths[((Integer)entry.getKey()).intValue()] = ((Integer)entry.getValue()).byteValue();
        }
        return widths;
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (sender == null) {
            this.sendMessage(null, this.getMessages().getCommandOnlyFromGame());
            return;
        }
        if (args.length == 1) {
            int i = Integer.parseInt(args[0]);
            if (i > 65535) {
                this.sendMessage(sender, "&cCharacter ID out of range: 0-65535");
                return;
            }
            int ROWS = 15;
            int COLUMNS = 10;
            StringBuilder line = new StringBuilder();
            for (int row = 0; row < ROWS; ++row) {
                line.append(".");
                for (int column = 0; column < COLUMNS; ++column) {
                    int character = row * COLUMNS + column + i;
                    if (character >= 65535) continue;
                    line.append(this.buildSpaces(21 - this.widths[character]));
                    line.append((char)character);
                    line.append("&e|&r");
                }
                line.append("   ").append(row * COLUMNS + i).append("-").append((row + 1) * COLUMNS + i - 1).append("\n");
            }
            IChatBaseComponent msg = IChatBaseComponent.fromColoredText(line + "\u00a77\u00a7l[Previous]");
            msg.getModifier().onClickRunCommand("/tab widthcheck " + (i - ROWS * COLUMNS));
            IChatBaseComponent next = new IChatBaseComponent("                                    \u00a77\u00a7l[Next]");
            next.getModifier().onClickRunCommand("/tab widthcheck " + (i + ROWS * COLUMNS));
            msg.addExtra(next);
            sender.sendMessage(msg);
        }
    }

    private String buildSpaces(int pixelWidth) {
        if (pixelWidth < 12) {
            throw new IllegalArgumentException("Cannot build space lower than 12 pixels wide (" + pixelWidth + ")");
        }
        int pixelsLeft = pixelWidth;
        StringBuilder output = new StringBuilder();
        while (pixelsLeft % 5 != 0) {
            pixelsLeft -= 4;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('l');
        while (pixelsLeft > 0) {
            pixelsLeft -= 5;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('r');
        return output.toString();
    }
}

