/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;
import org.yaml.snakeyaml.error.YAMLException;

public class MessageFile
extends YamlConfigurationFile {
    public MessageFile() throws YAMLException, IOException {
        super(MessageFile.class.getClassLoader().getResourceAsStream("messages.yml"), new File(TAB.getInstance().getDataFolder(), "messages.yml"));
    }

    public String getAnnounceCommandUsage() {
        return this.getString("announce-command-usage", "Usage: /tab announce <type> <name> <length>\nCurrently supported types: &lbar, scoreboard");
    }

    public String getBossBarNotEnabled() {
        return this.getString("bossbar-feature-not-enabled", "&cThis command requires the bossbar feature to be enabled.");
    }

    public String getBossBarAnnounceCommandUsage() {
        return this.getString("bossbar-announce-command-usage", "Usage: /tab announce bar <bar name> <length>");
    }

    public String getBossBarNotFound(String name) {
        return this.getString("bossbar-not-found", "&cNo bossbar found with the name \"%name%\"").replace("%name%", name);
    }

    public String getBossBarAlreadyAnnounced() {
        return this.getString("bossbar-already-announced", "&cThis bossbar is already being announced");
    }

    public String getGroupDataRemoved(String group) {
        return this.getString("group-data-removed", "&3[TAB] All data has been successfully removed from group &e%group%").replace("%group%", group);
    }

    public String getGroupValueAssigned(String property, String value, String group) {
        return this.getString("group-value-assigned", "&3[TAB] %property% '&r%value%&r&3' has been successfully assigned to group &e%group%").replace("%property%", property).replace("%value%", value).replace("%group%", group);
    }

    public String getGroupValueRemoved(String property, String group) {
        return this.getString("group-value-removed", "&3[TAB] %property% has been successfully removed from group &e%group%").replace("%property%", property).replace("%group%", group);
    }

    public String getPlayerDataRemoved(String player) {
        return this.getString("user-data-removed", "&3[TAB] All data has been successfully removed from player &e%player%").replace("%player%", player);
    }

    public String getPlayerValueAssigned(String property, String value, String player) {
        return this.getString("user-value-assigned", "&3[TAB] %property% '&r%value%&r&3' has been successfully assigned to player &e%player%").replace("%property%", property).replace("%value%", value).replace("%player%", player);
    }

    public String getPlayerValueRemoved(String property, String player) {
        return this.getString("user-value-removed", "&3[TAB] %property% has been successfully removed from player &e%player%").replace("%property%", property).replace("%player%", player);
    }

    public String getParseCommandUsage() {
        return this.getString("parse-command-usage", "Usage: /tab parse <player> <placeholder>");
    }

    public String getSendCommandUsage() {
        return this.getString("send-command-usage", "Usage: /tab send <type> <player> <bar name> <length>\nCurrently supported types: &lbar");
    }

    public String getSendBarCommandUsage() {
        return this.getString("send-bar-command-usage", "Usage: /tab send bar <player> <bar name> <length>");
    }

    public String getTeamFeatureRequired() {
        return this.getString("team-feature-required", "This command requires scoreboard teams feature enabled");
    }

    public String getCollisionCommandUsage() {
        return this.getString("collision-command-ussage", "Usage: /tab setcollision <player> <true/false>");
    }

    public String getNoPermission() {
        return this.getString("no-permission", "&cI'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.");
    }

    public String getCommandOnlyFromGame() {
        return this.getString("command-only-from-game", "&cThis command must be ran from the game");
    }

    public String getPlayerNotFound(String name) {
        return this.getString("player-not-online", "&cNo online player found with the name \"%player%\"").replace("%player%", name);
    }

    public String getUnlimitedNametagModeNotEnabled() {
        return this.getString("unlimited-nametag-mode-not-enabled", "&c[TAB] Warning! To make this feature work, you need to enable unlimited-nametag-mode in the config!");
    }

    public String getInvalidNumber(String input) {
        return this.getString("invalid-number", "\"%input%\" is not a number!").replace("%input%", input);
    }

    public String getScoreboardFeatureNotEnabled() {
        return this.getString("scoreboard-feature-not-enabled", "&4This command requires the scoreboard feature to be enabled.");
    }

    public String getScoreboardAnnounceCommandUsage() {
        return this.getString("scoreboard-announce-command-usage", "Usage: /tab announce scoreboard <scoreboard name> <length>");
    }

    public String getScoreboardNotFound(String name) {
        return this.getString("scoreboard-not-found", "&cNo scoreboard found with the name \"%name%\"").replace("%name%", name);
    }

    public String getNametagPreviewOn() {
        return this.getString("nametag-preview-on", "&7Preview mode &aactivated&7.");
    }

    public String getNametagPreviewOff() {
        return this.getString("nametag-preview-of", "&7Preview mode &3deactivated&7.");
    }

    public String getReloadSuccess() {
        return this.getString("reload-success", "&3[TAB] Successfully reloaded");
    }

    public String getReloadFailBrokenFile() {
        return this.getString("reload-fail-file", "&3[TAB] &4Failed to reload, file %file% has broken syntax. Check console for more info.");
    }

    public String getScoreboardOn() {
        return this.getString("scoreboard-toggle-on", "&2Scoreboard enabled");
    }

    public String getScoreboardOff() {
        return this.getString("scoreboard-toggle-off", "&7Scoreboard disabled");
    }

    public String getBossBarOn() {
        return this.getString("bossbar-toggle-on", "&2Bossbar is now visible");
    }

    public String getBossBarOff() {
        return this.getString("bossbar-toggle-off", "&7Bossbar is no longer visible. Magic!");
    }

    public String getScoreboardShowUsage() {
        return this.getString("scoreboard-show-usage", "Usage: /tab scoreboard show <scoreboard> [player]");
    }

    public String getBossBarNotMarkedAsAnnouncement() {
        return this.getString("bossbar-not-marked-as-announcement", "&cThis bossbar is not marked as an announcement bar and is therefore already displayed permanently (if display condition is met)");
    }

    public String getBossBarAnnouncementSuccess(String bar, int length) {
        return this.getString("bossbar-announcement-success", "&aAnnouncing bossbar &6%bossbar% &afor %length% seconds.").replace("%bossbar%", bar).replace("%length%", String.valueOf(length));
    }

    public String getBossBarSendSuccess(String player, String bar, int length) {
        return this.getString("bossbar-send-success", "&aSending bossbar &6%bossbar% &ato player &6%player% &afor %length% seconds.").replace("%player%", player).replace("%bossbar%", bar).replace("%length%", String.valueOf(length));
    }

    public List<String> getHelpMenu() {
        return this.getStringList("help-menu", Arrays.asList("&m                                                                                ", " &8>> &3&l/tab reload", "    &7Reloads plugin and config", " &8>> &3&l/tab &9group&3/&9player &3<name> &9<property> &3<value...>", "    &7Do &8/tab group/player &7to show properties", " &8>> &3&l/tab nametag preview", "    &7Shows your nametag for yourself, for testing purposes", " &8>> &3&l/tab announce bar &3<name> &9<seconds>", "    &7Temporarily displays bossbar to all players", " &8>> &3&l/tab parse <player> <placeholder> ", "    &7Test if a placeholder works", " &8>> &3&l/tab debug [player]", "    &7displays debug information about player", " &8>> &3&l/tab cpu", "    &7shows CPU usage of the plugin", " &8>> &3&l/tab group/player <name> remove", "    &7Clears all data about player/group", "&m                                                                                "));
    }

    public List<String> getMySQLHelpMenu() {
        return this.getStringList("mysql-help-menu", Arrays.asList("/tab mysql upload - uploads data from files to mysql", "/tab mysql download - downloads data from mysql to files"));
    }

    public String getMySQLFailNotEnabled() {
        return this.getString("mysql-fail-not-enabled", "&cCannot download/upload data from/to MySQL, because it's disabled.");
    }

    public String getMySQLFailError() {
        return this.getString("mysql-fail-error", "MySQL download failed due to an error. Check console for more info.");
    }

    public String getMySQLDownloadSuccess() {
        return this.getString("mysql-download-success", "&aMySQL data downloaded successfully.");
    }

    public String getMySQLUploadSuccess() {
        return this.getString("mysql-upload-success", "&aMySQL data uploaded successfully.");
    }

    public List<String> getNameTagHelpMenu() {
        return this.getStringList("nametag-help-menu", Arrays.asList("/tab nametag preview - toggles armor stand preview mode", "/tab nametag toggle - toggles nametags on all players for command sender"));
    }

    public String getNameTagFeatureNotEnabled() {
        return this.getString("nametag-feature-not-enabled", "&cThis command requires nametag feature to be enabled.");
    }

    public String getNameTagsHidden() {
        return this.getString("nametags-hidden", "&aNametags of all players were hidden to you");
    }

    public String getNameTagsShown() {
        return this.getString("nametags-shown", "&aNametags of all players were shown to you");
    }

    public String getArmorStandsDisabledCannotPreview() {
        return this.getString("armorstands-disabled-cannot-use-preview", "&cYour armor stands are disabled, therefore you cannot use preview feature");
    }
}

