/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.event;

import java.lang.reflect.Method;
import me.neznamy.tab.api.event.EventBus;
import me.neznamy.tab.api.event.EventHandler;
import me.neznamy.tab.api.event.Subscribe;
import me.neznamy.tab.api.event.TabEvent;
import me.neznamy.tab.libs.net.kyori.event.EventSubscriber;
import me.neznamy.tab.libs.net.kyori.event.PostResult;
import me.neznamy.tab.libs.net.kyori.event.SimpleEventBus;
import me.neznamy.tab.libs.net.kyori.event.method.MethodHandleEventExecutorFactory;
import me.neznamy.tab.libs.net.kyori.event.method.MethodScanner;
import me.neznamy.tab.libs.net.kyori.event.method.MethodSubscriptionAdapter;
import me.neznamy.tab.libs.net.kyori.event.method.SimpleMethodSubscriptionAdapter;
import me.neznamy.tab.shared.TAB;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EventBusImpl
implements EventBus {
    private final SimpleEventBus<TabEvent> bus = new SimpleEventBus<TabEvent>(TabEvent.class){

        @Override
        protected boolean shouldPost(@NonNull TabEvent event, @NonNull EventSubscriber subscriber) {
            return true;
        }
    };
    private final MethodSubscriptionAdapter<Object> methodAdapter = new SimpleMethodSubscriptionAdapter<TabEvent, Object>(this.bus, new MethodHandleEventExecutorFactory(), new TabMethodScanner());

    public <E extends TabEvent> void fire(E event) {
        if (!this.bus.hasSubscribers(event.getClass())) {
            return;
        }
        PostResult result = this.bus.post(event);
        if (result.exceptions().isEmpty()) {
            return;
        }
        TAB.getInstance().getErrorManager().printError("Some errors occurred whilst trying to fire event " + event);
        int i = 0;
        for (Throwable exception : result.exceptions().values()) {
            TAB.getInstance().getErrorManager().printError("#" + i++ + ": \n", exception);
        }
    }

    @Override
    public void register(Object listener) {
        this.methodAdapter.register(listener);
    }

    @Override
    public <E extends TabEvent> void register(Class<E> type, EventHandler<E> handler) {
        this.bus.register(type, new HandlerWrapper<E>(handler));
    }

    @Override
    public void unregister(Object listener) {
        this.methodAdapter.unregister(listener);
    }

    @Override
    public <E extends TabEvent> void unregister(EventHandler<E> handler) {
        this.bus.unregister((EventSubscriber<?> subscriber) -> subscriber instanceof HandlerWrapper && ((HandlerWrapper)subscriber).handler == handler);
    }

    private static final class TabMethodScanner
    implements MethodScanner<Object> {
        private TabMethodScanner() {
        }

        @Override
        public boolean shouldRegister(@NonNull Object listener, @NonNull Method method) {
            return method.isAnnotationPresent(Subscribe.class);
        }

        @Override
        public int postOrder(@NonNull Object listener, @NonNull Method method) {
            return 0;
        }

        @Override
        public boolean consumeCancelledEvents(@NonNull Object listener, @NonNull Method method) {
            return true;
        }
    }

    private static final class HandlerWrapper<E>
    implements EventSubscriber<E> {
        private final EventHandler<E> handler;

        public HandlerWrapper(EventHandler<E> handler) {
            this.handler = handler;
        }

        @Override
        public void invoke(@NonNull E event) {
            this.handler.handle(event);
        }
    }
}

