/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.Arrays;
import java.util.Objects;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.redis.RedisSupport;

public class BelowName
extends TabFeature {
    public static final String OBJECTIVE_NAME = "TAB-BelowName";
    public static final int DISPLAY_SLOT = 2;
    private final String rawNumber = TAB.getInstance().getConfiguration().getConfig().getString("belowname-objective.number", "%health%");
    private final String rawText = TAB.getInstance().getConfiguration().getConfig().getString("belowname-objective.text", "Health");
    private final TabFeature textRefresher = new TextRefresher();

    public BelowName() {
        super("BelowName", "Updating BelowName number", "belowname-objective");
        TAB.getInstance().getFeatureManager().registerFeature("BelowNameText", this.textRefresher);
        TAB.getInstance().debug(String.format("Loaded BelowName feature with parameters number=%s, text=%s, disabledWorlds=%s, disabledServers=%s", this.rawNumber, this.rawText, Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers)));
    }

    @Override
    public void load() {
        for (TabPlayer loaded : TAB.getInstance().getOnlinePlayers()) {
            loaded.setProperty(this, "belowname-number", this.rawNumber);
            loaded.setProperty(this.textRefresher, "belowname-text", this.rawText);
            if (this.isDisabled(loaded.getServer(), loaded.getWorld())) {
                this.addDisabledPlayer(loaded);
                continue;
            }
            loaded.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, loaded.getProperty("belowname-text").updateAndGet(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), this.textRefresher);
            loaded.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(2, OBJECTIVE_NAME), this.textRefresher);
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(viewer)) continue;
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (!this.sameServerAndWorld(target, viewer)) continue;
                viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, target.getNickname(), this.getValue(target)), this);
            }
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(p)) continue;
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(OBJECTIVE_NAME), this.textRefresher);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        connectedPlayer.setProperty(this, "belowname-number", this.rawNumber);
        connectedPlayer.setProperty(this.textRefresher, "belowname-text", this.rawText);
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, connectedPlayer.getProperty("belowname-text").updateAndGet(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), this.textRefresher);
        connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(2, OBJECTIVE_NAME), this.textRefresher);
        int number = this.getValue(connectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!this.sameServerAndWorld(all, connectedPlayer)) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, connectedPlayer.getNickname(), number), this);
            connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, all.getNickname(), this.getValue(all)), this);
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateBelowName(connectedPlayer, connectedPlayer.getProperty("belowname-number").get());
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        boolean disabledNow = false;
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            disabledNow = true;
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        if (disabledNow && !disabledBefore) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(OBJECTIVE_NAME), this.textRefresher);
            return;
        }
        if (!disabledNow && disabledBefore) {
            this.onJoin(p);
            return;
        }
        if (disabledNow) {
            return;
        }
        int number = this.getValue(p);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!this.sameServerAndWorld(all, p)) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, p.getNickname(), number), this);
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, all.getNickname(), this.getValue(all)), this);
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateBelowName(p, p.getProperty("belowname-number").get());
        }
    }

    public int getValue(TabPlayer p) {
        return TAB.getInstance().getErrorManager().parseInteger(p.getProperty("belowname-number").updateAndGet(), 0);
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (this.isDisabledPlayer(refreshed)) {
            return;
        }
        int number = this.getValue(refreshed);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!this.sameServerAndWorld(all, refreshed)) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, refreshed.getNickname(), number), this);
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateBelowName(refreshed, refreshed.getProperty("belowname-number").get());
        }
    }

    @Override
    public void onLoginPacket(TabPlayer packetReceiver) {
        if (this.isDisabledPlayer(packetReceiver)) {
            return;
        }
        packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, packetReceiver.getProperty("belowname-text").updateAndGet(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), this.textRefresher);
        packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(2, OBJECTIVE_NAME), this.textRefresher);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!all.isLoaded() || !this.sameServerAndWorld(all, packetReceiver)) continue;
            packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, all.getNickname(), this.getValue(all)), this);
        }
    }

    private boolean sameServerAndWorld(TabPlayer player1, TabPlayer player2) {
        return player2.getWorld().equals(player1.getWorld()) && Objects.equals(player2.getServer(), player1.getServer());
    }

    public class TextRefresher
    extends TabFeature {
        public TextRefresher() {
            super("BelowName", "Updating BelowName text");
        }

        @Override
        public void refresh(TabPlayer refreshed, boolean force) {
            if (this.isDisabledPlayer(refreshed)) {
                return;
            }
            refreshed.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(2, BelowName.OBJECTIVE_NAME, refreshed.getProperty("belowname-text").updateAndGet(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), BelowName.this.textRefresher);
        }
    }
}

