/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.HeaderFooterManager;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;

public class HeaderFooter
extends TabFeature
implements HeaderFooterManager {
    private final List<Object> worldGroups = new ArrayList(TAB.getInstance().getConfig().getConfigurationSection("header-footer.per-world").keySet());
    private final List<Object> serverGroups = new ArrayList(TAB.getInstance().getConfig().getConfigurationSection("header-footer.per-server").keySet());

    public HeaderFooter() {
        super("Header/Footer", "Updating header/footer", "header-footer");
        TAB.getInstance().debug(String.format("Loaded HeaderFooter feature with parameters disabledWorlds=%s, disabledServers=%s", Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers)));
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(p) || p.getVersion().getMinorVersion() < 8) continue;
            p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter("", ""), this);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        this.refresh(connectedPlayer, true);
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        boolean disabledNow = false;
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            disabledNow = true;
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        if (p.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (disabledNow) {
            if (!disabledBefore) {
                p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter("", ""), this);
            }
        } else {
            boolean refresh = p.setProperty(this, "header", this.getProperty(p, "header"));
            if (p.setProperty(this, "footer", this.getProperty(p, "footer"))) {
                refresh = true;
            }
            if (refresh || disabledBefore) {
                p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(p.getProperty("header").get(), p.getProperty("footer").get()), this);
            }
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (force) {
            p.setProperty(this, "header", this.getProperty(p, "header"));
            p.setProperty(this, "footer", this.getProperty(p, "footer"));
        }
        if (this.isDisabledPlayer(p) || p.getVersion().getMinorVersion() < 8) {
            return;
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(p.getProperty("header").updateAndGet(), p.getProperty("footer").updateAndGet()), this);
    }

    private String getProperty(TabPlayer p, String property) {
        String append = this.getFromConfig(p, property + "append");
        if (append.length() > 0) {
            append = "\n\u00a7r" + append;
        }
        return this.getFromConfig(p, property) + append;
    }

    private String getFromConfig(TabPlayer p, String property) {
        String[] value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getName(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getUniqueId().toString(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getGroups().getProperty(p.getGroup(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        List<String> lines = TAB.getInstance().getConfiguration().getConfig().getStringList("header-footer.per-server." + TAB.getInstance().getConfiguration().getGroup(this.serverGroups, p.getServer()) + "." + property);
        if (lines == null) {
            lines = TAB.getInstance().getConfiguration().getConfig().getStringList("header-footer.per-world." + TAB.getInstance().getConfiguration().getGroup(this.worldGroups, p.getWorld()) + "." + property);
        }
        if (lines == null) {
            lines = TAB.getInstance().getConfiguration().getConfig().getStringList("header-footer." + property);
        }
        if (lines == null) {
            lines = new ArrayList<String>();
        }
        return String.join((CharSequence)"\n\u00a7r", lines);
    }

    @Override
    public void setHeader(TabPlayer player, String header) {
        player.getProperty("header").setTemporaryValue(header);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }

    @Override
    public void setFooter(TabPlayer player, String footer) {
        player.getProperty("footer").setTemporaryValue(footer);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }

    @Override
    public void setHeaderAndFooter(TabPlayer player, String header, String footer) {
        player.getProperty("header").setTemporaryValue(header);
        player.getProperty("footer").setTemporaryValue(footer);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }

    @Override
    public void resetHeader(TabPlayer player) {
        player.getProperty("header").setTemporaryValue(null);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }

    @Override
    public void resetFooter(TabPlayer player) {
        player.getProperty("footer").setTemporaryValue(null);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }

    @Override
    public void resetHeaderAndFooter(TabPlayer player) {
        player.getProperty("header").setTemporaryValue(null);
        player.getProperty("footer").setTemporaryValue(null);
        player.sendCustomPacket((TabPacket)new PacketPlayOutPlayerListHeaderFooter(player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet()), this);
    }
}

